/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MACH_IMX8M_REGS_H
#define __MACH_IMX8M_REGS_H

#include <linux/compiler.h>

/*
 * Actual addressable OCRAM size may differ from SoC to SoC, but all of
 * i.MX8MQ/M/N/P have this region of MMIO address space set aside for
 * OCRAM only.
 */
#define	MX8M_OCRAM_BASE_ADDR		0x00900000
#define	MX8M_OCRAM_MAX_SIZE		0x00200000

#define MX8M_GPIO1_BASE_ADDR		0X30200000
#define MX8M_GPIO2_BASE_ADDR		0x30210000
#define MX8M_GPIO3_BASE_ADDR		0x30220000
#define MX8M_GPIO4_BASE_ADDR		0x30230000
#define MX8M_GPIO5_BASE_ADDR		0x30240000
#define MX8M_WDOG1_BASE_ADDR		0x30280000
#define MX8M_WDOG2_BASE_ADDR		0x30290000
#define MX8M_WDOG3_BASE_ADDR		0x302A0000
#define MX8M_IOMUXC_BASE_ADDR		0x30330000
#define MX8M_IOMUXC_GPR_BASE_ADDR	0x30340000
#define MX8M_OCOTP_BASE_ADDR		0x30350000
#define MX8M_ANATOP_BASE_ADDR		0x30360000
#define MX8M_CCM_BASE_ADDR		0x30380000
#define MX8M_SRC_BASE_ADDR		0x30390000
#define MX8M_SRC_DDRC_RCR_ADDR		0x30391000
#define MX8M_GPC_BASE_ADDR		0x303A0000
#define MX8M_SYSCNT_CTRL_BASE_ADDR	0x306C0000
#define MX8M_UART1_BASE_ADDR		0x30860000
#define MX8M_UART3_BASE_ADDR		0x30880000
#define MX8M_UART2_BASE_ADDR		0x30890000
#define MX8M_CAAM_BASE_ADDR		IOMEM(0x30900000)
#define MX8M_I2C1_BASE_ADDR		0x30A20000
#define MX8M_I2C2_BASE_ADDR		0x30A30000
#define MX8M_I2C3_BASE_ADDR		0x30A40000
#define MX8M_I2C4_BASE_ADDR		0x30A50000
#define MX8M_UART4_BASE_ADDR		0x30A60000
#define MX8M_USDHC1_BASE_ADDR		0x30B40000
#define MX8M_USDHC2_BASE_ADDR		0x30B50000
#define MX8M_TZASC_BASE_ADDR		0x32f80000
#define MX8M_DDRC_PHY_BASE_ADDR		0x3c000000
#define MX8M_DDRC_DDR_SS_GPR0		(MX8M_DDRC_PHY_BASE_ADDR + 0x01000000)
#define MX8M_DDRC_IPS_BASE_ADDR(X)	(0x3d400000 + ((X) * 0x2000000))
#define MX8M_DDRC_CTL_BASE_ADDR		MX8M_DDRC_IPS_BASE_ADDR(0)
#define MX8M_DDR_CSD1_BASE_ADDR		0x40000000

#endif /* __MACH_IMX8M_REGS_H */
