/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MACH_IMX6_REGS_H
#define __MACH_IMX6_REGS_H

#define MX6_GPMI_BASE_ADDR		0x00112000

#define MX6_FAST1_BASE_ADDR		0x00c00000
#define MX6_FAST2_BASE_ADDR		0x00b00000

#define MX6_AIPS1_ARB_BASE_ADDR		0x02000000
#define MX6_AIPS2_ARB_BASE_ADDR		0x02100000

#define MX6_AIPS3_ARB_BASE_ADDR		0x02200000
#define MX6_AIPS3_ARB_END_ADDR		0x022FFFFF

/* Defines for Blocks connected via AIPS (SkyBlue) */
#define MX6_ATZ1_BASE_ADDR              MX6_AIPS1_ARB_BASE_ADDR
#define MX6_ATZ2_BASE_ADDR              MX6_AIPS2_ARB_BASE_ADDR
#define MX6_ATZ3_BASE_ADDR              MX6_AIPS3_ARB_BASE_ADDR

/* slots 0,7 of SDMA reserved, therefore left unused in IPMUX3 */
#define MX6_SPDIF_BASE_ADDR             (MX6_ATZ1_BASE_ADDR + 0x04000)
#define MX6_ECSPI1_BASE_ADDR            (MX6_ATZ1_BASE_ADDR + 0x08000)
#define MX6_ECSPI2_BASE_ADDR            (MX6_ATZ1_BASE_ADDR + 0x0C000)
#define MX6_ECSPI3_BASE_ADDR            (MX6_ATZ1_BASE_ADDR + 0x10000)
#define MX6_ECSPI4_BASE_ADDR            (MX6_ATZ1_BASE_ADDR + 0x14000)
#define MX6_ECSPI5_BASE_ADDR            (MX6_ATZ1_BASE_ADDR + 0x18000)
#define MX6_UART1_BASE_ADDR             (MX6_ATZ1_BASE_ADDR + 0x20000)
#define MX6_ESAI1_BASE_ADDR             (MX6_ATZ1_BASE_ADDR + 0x24000)
#define MX6_SSI1_BASE_ADDR              (MX6_ATZ1_BASE_ADDR + 0x28000)
#define MX6_SSI2_BASE_ADDR              (MX6_ATZ1_BASE_ADDR + 0x2C000)
#define MX6_SSI3_BASE_ADDR              (MX6_ATZ1_BASE_ADDR + 0x30000)
#define MX6_ASRC_BASE_ADDR              (MX6_ATZ1_BASE_ADDR + 0x34000)
#define MX6_SPBA_BASE_ADDR              (MX6_ATZ1_BASE_ADDR + 0x3C000)
#define MX6_VPU_BASE_ADDR               (MX6_ATZ1_BASE_ADDR + 0x40000)

#define MX6_IPU1_BASE_ADDR		0x02400000
#define MX6_IPU2_BASE_ADDR		0x02800000

/* ATZ#1- On Platform */
#define MX6_AIPS1_ON_BASE_ADDR          (MX6_ATZ1_BASE_ADDR + 0x7C000)

/* ATZ#1- Off Platform */
#define MX6_AIPS1_OFF_BASE_ADDR         (MX6_ATZ1_BASE_ADDR + 0x80000)

#define MX6_PWM1_BASE_ADDR              (MX6_AIPS1_OFF_BASE_ADDR + 0x0000)
#define MX6_PWM2_BASE_ADDR              (MX6_AIPS1_OFF_BASE_ADDR + 0x4000)
#define MX6_PWM3_BASE_ADDR              (MX6_AIPS1_OFF_BASE_ADDR + 0x8000)
#define MX6_PWM4_BASE_ADDR              (MX6_AIPS1_OFF_BASE_ADDR + 0xC000)
#define MX6_CAN1_BASE_ADDR              (MX6_AIPS1_OFF_BASE_ADDR + 0x10000)
#define MX6_CAN2_BASE_ADDR              (MX6_AIPS1_OFF_BASE_ADDR + 0x14000)
#define MX6_GPT_BASE_ADDR               (MX6_AIPS1_OFF_BASE_ADDR + 0x18000)
#define MX6_GPIO1_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x1C000)
#define MX6_GPIO2_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x20000)
#define MX6_GPIO3_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x24000)
#define MX6_GPIO4_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x28000)
#define MX6_GPIO5_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x2C000)
#define MX6_GPIO6_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x30000)
#define MX6_GPIO7_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x34000)
#define MX6_KPP_BASE_ADDR               (MX6_AIPS1_OFF_BASE_ADDR + 0x38000)
#define MX6_WDOG1_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x3C000)
#define MX6_WDOG2_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x40000)
#define MX6_CCM_BASE_ADDR               (MX6_AIPS1_OFF_BASE_ADDR + 0x44000)
#define MX6_ANATOP_BASE_ADDR            (MX6_AIPS1_OFF_BASE_ADDR + 0x48000)
#define MX6_USBPHY1_BASE_ADDR		(MX6_AIPS1_OFF_BASE_ADDR + 0x49000)
#define MX6_USBPHY2_BASE_ADDR		(MX6_AIPS1_OFF_BASE_ADDR + 0x4a000)
#define MX6_SNVS_BASE_ADDR              (MX6_AIPS1_OFF_BASE_ADDR + 0x4C000)
#define MX6_EPIT1_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x50000)
#define MX6_EPIT2_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x54000)
#define MX6_SRC_BASE_ADDR               (MX6_AIPS1_OFF_BASE_ADDR + 0x58000)
#define MX6_GPC_BASE_ADDR               (MX6_AIPS1_OFF_BASE_ADDR + 0x5C000)
#define MX6_IOMUXC_BASE_ADDR            (MX6_AIPS1_OFF_BASE_ADDR + 0x60000)
#define MX6_DCIC1_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x64000)
#define MX6_DCIC2_BASE_ADDR             (MX6_AIPS1_OFF_BASE_ADDR + 0x68000)
#define MX6_DMA_REQ_PORT_HOST_BASE_ADDR (MX6_AIPS1_OFF_BASE_ADDR + 0x6C000)

/* ATZ#2- On Platform */
#define MX6_AIPS2_ON_BASE_ADDR          (MX6_ATZ2_BASE_ADDR + 0x7C000)

/* ATZ#2- Off Platform */
#define MX6_AIPS2_OFF_BASE_ADDR         (MX6_ATZ2_BASE_ADDR + 0x80000)

/* ATZ#2  - Global enable (0) */
#define MX6_CAAM_BASE_ADDR              (MX6_ATZ2_BASE_ADDR)
#define MX6_ARM_BASE_ADDR		(MX6_ATZ2_BASE_ADDR + 0x40000)

/* ATZ#3- On Platform */
#define MX6_AIPS3_ON_BASE_ADDR          (MX6_ATZ3_BASE_ADDR + 0x7C000)

/* ATZ#2- Off Platform */
#define MX6_AIPS3_OFF_BASE_ADDR         (MX6_ATZ3_BASE_ADDR + 0x80000)

#define MX6_USBOH3_PL301_BASE_ADDR      (MX6_AIPS2_OFF_BASE_ADDR + 0x0000)
#define MX6_USBOH3_USB_BASE_ADDR        (MX6_AIPS2_OFF_BASE_ADDR + 0x4000)
#define MX6_OTG_BASE_ADDR		MX6_USBOH3_USB_BASE_ADDR
#define MX6_ENET_BASE_ADDR              (MX6_AIPS2_OFF_BASE_ADDR + 0x8000)
#define MX6_MLB_BASE_ADDR               (MX6_AIPS2_OFF_BASE_ADDR + 0xC000)

#define MX6_USDHC1_BASE_ADDR            (MX6_AIPS2_OFF_BASE_ADDR + 0x10000)
#define MX6_USDHC2_BASE_ADDR            (MX6_AIPS2_OFF_BASE_ADDR + 0x14000)
#define MX6_USDHC3_BASE_ADDR            (MX6_AIPS2_OFF_BASE_ADDR + 0x18000)
#define MX6_USDHC4_BASE_ADDR            (MX6_AIPS2_OFF_BASE_ADDR + 0x1C000)
#define MX6_I2C1_BASE_ADDR              (MX6_AIPS2_OFF_BASE_ADDR + 0x20000)
#define MX6_I2C2_BASE_ADDR              (MX6_AIPS2_OFF_BASE_ADDR + 0x24000)
#define MX6_I2C3_BASE_ADDR              (MX6_AIPS2_OFF_BASE_ADDR + 0x28000)
#define MX6_ROMCP_BASE_ADDR             (MX6_AIPS2_OFF_BASE_ADDR + 0x2C000)
#define MX6_MMDC_P0_BASE_ADDR           (MX6_AIPS2_OFF_BASE_ADDR + 0x30000)
#define MX6_MMDC_P1_BASE_ADDR           (MX6_AIPS2_OFF_BASE_ADDR + 0x34000)
#define MX6_WEIM_BASE_ADDR              (MX6_AIPS2_OFF_BASE_ADDR + 0x38000)
#define MX6_OCOTP_BASE_ADDR             (MX6_AIPS2_OFF_BASE_ADDR + 0x3C000)
#define MX6_CSU_BASE_ADDR               (MX6_AIPS2_OFF_BASE_ADDR + 0x40000)
#define MX6_IP2APB_PERFMON1_BASE_ADDR   (MX6_AIPS2_OFF_BASE_ADDR + 0x44000)
#define MX6_IP2APB_PERFMON2_BASE_ADDR   (MX6_AIPS2_OFF_BASE_ADDR + 0x48000)
#define MX6_IP2APB_PERFMON3_BASE_ADDR   (MX6_AIPS2_OFF_BASE_ADDR + 0x4C000)
#define MX6_IP2APB_TZASC1_BASE_ADDR     (MX6_AIPS2_OFF_BASE_ADDR + 0x50000)
#define MX6_IP2APB_TZASC2_BASE_ADDR     (MX6_AIPS2_OFF_BASE_ADDR + 0x54000)
#define MX6_AUDMUX_BASE_ADDR            (MX6_AIPS2_OFF_BASE_ADDR + 0x58000)
#define MX6_MIPI_CSI2_BASE_ADDR         (MX6_AIPS2_OFF_BASE_ADDR + 0x5C000)
#define MX6_MIPI_DSI_BASE_ADDR          (MX6_AIPS2_OFF_BASE_ADDR + 0x60000)
#define MX6_VDOA_BASE_ADDR              (MX6_AIPS2_OFF_BASE_ADDR + 0x64000)
#define MX6ULL_WDOG3_BASE_ADDR          (MX6_AIPS2_OFF_BASE_ADDR + 0x64000)
#define MX6_UART2_BASE_ADDR             (MX6_AIPS2_OFF_BASE_ADDR + 0x68000)
#define MX6_UART3_BASE_ADDR             (MX6_AIPS2_OFF_BASE_ADDR + 0x6C000)
#define MX6_UART4_BASE_ADDR             (MX6_AIPS2_OFF_BASE_ADDR + 0x70000)
#define MX6_UART5_BASE_ADDR             (MX6_AIPS2_OFF_BASE_ADDR + 0x74000)
#define MX6_IP2APB_USBPHY1_BASE_ADDR    (MX6_AIPS2_OFF_BASE_ADDR + 0x78000)
#define MX6_IP2APB_USBPHY2_BASE_ADDR    (MX6_AIPS2_OFF_BASE_ADDR + 0x7C000)

#define MX6_UART7_BASE_ADDR		0x02018000
#define MX6_SATA_BASE_ADDR		0x02200000

#define MX6_MMDC_PORT01_BASE_ADDR	0x10000000
#define MX6_MMDC_PORT0_BASE_ADDR	0x80000000


#endif /* __MACH_IMX6_REGS_H */
