// SPDX-License-Identifier: GPL-2.0-only AND BSD-1-Clause
/*
 * Copyright (C) 2014, Atmel Corporation
 * Copyright (C) 2018 Ahmad Fatoum, Pengutronix
 */

#include <common.h>
#include <init.h>

#include <asm/barebox-arm-head.h>
#include <debug_ll.h>
#include <mach/barebox-arm.h>
#include <mach/iomux.h>
#include <mach/sama5d3.h>
#include <mach/sama5d3-xplained-ddramc.h>
#include <mach/xload.h>

/* PCK = 528MHz, MCK = 132MHz */
#define MASTER_CLOCK	132000000

static void dbgu_init(void)
{
	void __iomem *pio = IOMEM(SAMA5D3_BASE_PIOB);

	sama5d3_pmc_enable_periph_clock(SAMA5D3_ID_PIOB);

	at91_mux_pio3_pin(pio, pin_to_mask(AT91_PIN_PB31), AT91_MUX_PERIPH_A, 0);

	sama5d3_pmc_enable_periph_clock(SAMA5D3_ID_DBGU);
	at91_dbgu_setup_ll(IOMEM(AT91_BASE_DBGU1), MASTER_CLOCK, 115200);

	putc_ll('>');
}

SAMA5_ENTRY_FUNCTION(start_sama5d3_xplained_ung8071_xload_mmc, r4)
{
	sama5d3_lowlevel_init();

	relocate_to_current_adr();
	setup_c();

	sama5d3_udelay_init(MASTER_CLOCK);
	sama5d3_xplained_ddrconf();
	if (IS_ENABLED(CONFIG_DEBUG_LL))
		dbgu_init();

	sama5d3_atmci_start_image(0, MASTER_CLOCK, 0);
}

extern char __dtb_z_at91_microchip_ksz9477_evb_start[];

SAMA5_ENTRY_FUNCTION(start_sama5d3_xplained_ung8071, r4)
{
	void *fdt;

	arm_setup_stack(SAMA5D3_SRAM_BASE + SAMA5D3_SRAM_SIZE);

	if (IS_ENABLED(CONFIG_DEBUG_LL))
		dbgu_init();

	fdt = __dtb_z_at91_microchip_ksz9477_evb_start + get_runtime_offset();

	barebox_arm_entry(SAMA5_DDRCS, SZ_256M, fdt);
}
