/*
 * (C) Copyright 2004, Psyent Corporation <www.psyent.com>
 * Scott McNutt <smcnutt@psyent.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <asm/ptrace.h>
#include <common.h>

void trap_handler (struct pt_regs *regs)
{
	/* Just issue warning */
	printf("\n\n*** WARNING: unimplemented trap @ %08x\n\n",
			regs->reg[29] - 4);
}

void soft_emulation(struct pt_regs *regs)
{
	/* TODO: Software emulation of mul/div etc. Until this is
	 * implemented, generate warning and hang.
	 */
	printf("\n\n*** ERROR: unimplemented instruction @ %08x\n",
			regs->reg[29] - 4);

	hang();
}
