/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <common.h>
#include <init.h>
#include <io.h>
#include <mach/omap4-silicon.h>
#include <mach/omap4-mux.h>
#include <mach/omap4-clock.h>
#include "mux.h"

static const struct pad_conf_entry core_padconf_array[] = {
	{ GPMC_AD0            , IEN | PTU | M1 },
	{ GPMC_AD1            , IEN | PTU | M1 },
	{ GPMC_AD2            , IEN | PTU | M1 },
	{ GPMC_AD3            , IEN | PTU | M1 },
	{ GPMC_AD4            , IEN | PTU | M1 },
	{ GPMC_AD5            , IEN | PTU | M1 },
	{ GPMC_AD6            , IEN | PTU | M1 },
	{ GPMC_AD7            , IEN | PTU | M1 },
	{ GPMC_AD8            , IEN | PTD | M3 },
	{ GPMC_AD9            , IEN | PTU | M0 },
	{ GPMC_AD10           , IEN | PTU | M3 },
	{ GPMC_AD11           , IEN | PTU | M3 },
	{ GPMC_AD12           , IEN | PTD | M3 },
	{ GPMC_AD13           ,       PTD | M3 },
	{ GPMC_AD14           ,       PTD | M3 },
	{ GPMC_AD15           ,       PTD | M3 },
	{ GPMC_A16            , IEN | PTD | M7 },
	{ GPMC_A17            , IEN | PTD | M3 },
	{ GPMC_A18            , IEN | PTD | M1 },
	{ GPMC_A19            , IEN | PTU | M3 },
	{ GPMC_A20            , IEN | PTU | M3 },
	{ GPMC_A21            , IEN | PTD | M7 },
	{ GPMC_A22            , IEN | PTD | M1 },
	{ GPMC_A23            , IEN | PTD | M1 },
	{ GPMC_A24            , IEN | PTD | M3 },
	{ GPMC_A25            , IEN | PTU | M3 },
	{ GPMC_NCS0           , IEN | PTU | M0 },
	{ GPMC_NCS1           , IEN | PTU | M7 },
	{ GPMC_NCS2           , IEN | PTU | M7 },
	{ GPMC_NCS3           , IEN | PTU | M3 },
	{ GPMC_NWP            , IEN | PTD | M0 },
	{ GPMC_CLK            , IEN | PTD | M0 },
	{ GPMC_NADV_ALE       , IEN | PTD | M0 },
	{ GPMC_NOE            , IEN | PTU | M1 },
	{ GPMC_NWE            , IEN | PTU | M1 },
	{ GPMC_NBE0_CLE       , IEN | PTD | M0 },
	{ GPMC_NBE1           , IEN | PTD | M7 },
	{ GPMC_WAIT0          , IEN | PTU | M0 },
	{ GPMC_WAIT1          , IEN | PTU | M7 },
	{ GPMC_WAIT2          , IEN | PTD | M7 },
	{ GPMC_NCS4           , IEN | PTD | M3 },
	{ GPMC_NCS5           , IEN | PTD | M7 },
	{ GPMC_NCS6           , IEN | PTD | M7 },
	{ GPMC_NCS7           , IEN | PTD | M7 },
	{ GPIO63              ,             M0 },
	{ GPIO64              ,             M0 },
	{ GPIO65              ,             M0 },
	{ GPIO66              , IEN       | M0 },
	{ CSI21_DX0           , IEN | PTD | M7 },
	{ CSI21_DY0           , IEN | PTD | M7 },
	{ CSI21_DX1           , IEN | PTD | M7 },
	{ CSI21_DY1           , IEN | PTD | M7 },
	{ CSI21_DX2           , IEN | PTD | M7 },
	{ CSI21_DY2           , IEN | PTD | M7 },
	{ CSI21_DX3           , IEN | PTD | M7 },
	{ CSI21_DY3           , IEN | PTD | M7 },
	{ CSI21_DX4           , IEN | PTD | M7 },
	{ CSI21_DY4           , IEN | PTD | M7 },
	{ CSI22_DX0           , IEN | PTD | M7 },
	{ CSI22_DY0           , IEN | PTD | M7 },
	{ CSI22_DX1           , IEN | PTD | M7 },
	{ CSI22_DY1           , IEN | PTD | M7 },
	{ CAM_SHUTTER         ,       PTD | M0 },
	{ CAM_STROBE          ,       PTD | M0 },
	{ CAM_GLOBALRESET     ,       PTD | M3 },
	{ USBB1_ULPITLL_CLK   , IEN | PTD | M0 },
	{ USBB1_ULPITLL_STP   ,       PTU | M0 },
	{ USBB1_ULPITLL_DIR   , IEN | PTD | M0 },
	{ USBB1_ULPITLL_NXT   , IEN | PTD | M0 },
	{ USBB1_ULPITLL_DAT0  , IEN | PTD | M0 },
	{ USBB1_ULPITLL_DAT1  , IEN | PTD | M0 },
	{ USBB1_ULPITLL_DAT2  , IEN | PTD | M0 },
	{ USBB1_ULPITLL_DAT3  , IEN | PTD | M0 },
	{ USBB1_ULPITLL_DAT4  , IEN | PTD | M0 },
	{ USBB1_ULPITLL_DAT5  , IEN | PTD | M0 },
	{ USBB1_ULPITLL_DAT6  , IEN | PTD | M0 },
	{ USBB1_ULPITLL_DAT7  , IEN | PTD | M0 },
	{ USBB1_HSIC_DATA     ,             M0 },
	{ USBB1_HSIC_STROBE   ,             M0 },
	{ USBC1_ICUSB_DP      ,             M0 },
	{ USBC1_ICUSB_DM      ,             M0 },
	{ SDMMC1_CLK          ,       PTU | M0 },
	{ SDMMC1_CMD          , IEN | PTU | M0 },
	{ SDMMC1_DAT0         , IEN | PTU | M0 },
	{ SDMMC1_DAT1         , IEN | PTU | M0 },
	{ SDMMC1_DAT2         , IEN | PTU | M0 },
	{ SDMMC1_DAT3         , IEN | PTU | M0 },
	{ SDMMC1_DAT4         , IEN | PTU | M0 },
	{ SDMMC1_DAT5         , IEN | PTU | M0 },
	{ SDMMC1_DAT6         , IEN | PTU | M0 },
	{ SDMMC1_DAT7         , IEN | PTU | M0 },
	{ ABE_MCBSP2_CLKX     , IEN       | M0 },
	{ ABE_MCBSP2_DR       , IEN       | M0 },
	{ ABE_MCBSP2_DX       ,             M0 },
	{ ABE_MCBSP2_FSX      , IEN       | M0 },
	{ ABE_MCBSP1_CLKX     , IEN | PTD | M7 },
	{ ABE_MCBSP1_DR       , IEN | PTD | M7 },
	{ ABE_MCBSP1_DX       ,             M0 },
	{ ABE_MCBSP1_FSX      , IEN       | M0 },
	{ ABE_PDM_UL_DATA     , IEN | PTD | M7 },
	{ ABE_PDM_DL_DATA     , IEN | PTD | M7 },
	{ ABE_PDM_FRAME       , IEN | PTD | M7 },
	{ ABE_PDM_LB_CLK      , IEN | PTD | M7 },
	{ ABE_CLKS            , IEN | PTD | M7 },
	{ ABE_DMIC_CLK1       , IEN | PTD | M7 },
	{ ABE_DMIC_DIN1       , IEN | PTD | M7 },
	{ ABE_DMIC_DIN2       , IEN | PTD | M3 },
	{ ABE_DMIC_DIN3       , IEN | PTD | M3 },
	{ UART2_CTS           , IEN | PTU | M0 },
	{ UART2_RTS           ,             M0 },
	{ UART2_RX            , IEN       | M0 },
	{ UART2_TX            ,             M0 },
	{ HDQ_SIO             , IEN       | M7 },
	{ I2C1_SCL            , IEN       | M0 },
	{ I2C1_SDA            , IEN       | M0 },
	{ I2C2_SCL            , IEN       | M0 },
	{ I2C2_SDA            , IEN       | M0 },
	{ I2C3_SCL            , IEN       | M0 },
	{ I2C3_SDA            , IEN       | M0 },
	{ I2C4_SCL            , IEN       | M0 },
	{ I2C4_SDA            , IEN       | M0 },
	{ MCSPI1_CLK          , IEN       | M0 },
	{ MCSPI1_SOMI         , IEN       | M0 },
	{ MCSPI1_SIMO         , IEN       | M0 },
	{ MCSPI1_CS0          , IEN | PTD | M0 },
	{ MCSPI1_CS1          , IEN | PTU | M1 },
	{ MCSPI1_CS2          ,             M3 },
	{ MCSPI1_CS3          , IEN | PTU | M7 },
	{ UART3_CTS_RCTX      ,             M1 },
	{ UART3_RTS_SD        ,             M0 },
	{ UART3_RX_IRRX       , IEN | PTU | M3 },
	{ UART3_TX_IRTX       ,             M0 },
	{ SDMMC5_CLK          ,       PTU | M0 },
	{ SDMMC5_CMD          , IEN | PTU | M0 },
	{ SDMMC5_DAT0         , IEN | PTU | M0 },
	{ SDMMC5_DAT1         , IEN | PTU | M0 },
	{ SDMMC5_DAT2         , IEN | PTU | M0 },
	{ SDMMC5_DAT3         , IEN | PTU | M0 },
	{ MCSPI4_CLK          , IEN       | M0 },
	{ MCSPI4_SIMO         , IEN       | M0 },
	{ MCSPI4_SOMI         , IEN       | M0 },
	{ MCSPI4_CS0          , IEN | PTD | M0 },
	{ UART4_RX            , IEN       | M0 },
	{ UART4_TX            ,             M0 },
	{ USBB2_ULPITLL_CLK   ,             M3 },
	{ USBB2_ULPITLL_STP   ,             M5 },
	{ USBB2_ULPITLL_DIR   ,             M5 },
	{ USBB2_ULPITLL_NXT   ,             M5 },
	{ USBB2_ULPITLL_DAT0  ,             M5 },
	{ USBB2_ULPITLL_DAT1  ,             M5 },
	{ USBB2_ULPITLL_DAT2  ,             M5 },
	{ USBB2_ULPITLL_DAT3  ,             M5 },
	{ USBB2_ULPITLL_DAT4  ,             M5 },
	{ USBB2_ULPITLL_DAT5  ,             M5 },
	{ USBB2_ULPITLL_DAT6  ,             M5 },
	{ USBB2_ULPITLL_DAT7  ,             M5 },
	{ USBB2_HSIC_DATA     ,             M3 },
	{ USBB2_HSIC_STROBE   ,             M3 },
	{ KPD_COL3            , IEN | PTD | M1 },
	{ KPD_COL4            , IEN | PTD | M1 },
	{ KPD_COL5            , IEN | PTD | M1 },
	{ KPD_COL0            , IEN | PTD | M1 },
	{ KPD_COL1            , IEN | PTD | M3 },
	{ KPD_COL2            , IEN | PTD | M3 },
	{ KPD_ROW3            , IEN | PTD | M1 },
	{ KPD_ROW4            , IEN | PTD | M1 },
	{ KPD_ROW5            , IEN | PTD | M1 },
	{ KPD_ROW0            , IEN | PTD | M1 },
	{ KPD_ROW1            , IEN | PTD | M1 },
	{ KPD_ROW2            , IEN | PTD | M1 },
	{ USBA0_OTG_CE        ,       PTU | M0 },
	{ USBA0_OTG_DP        ,             M0 },
	{ USBA0_OTG_DM        ,             M0 },
	{ FREF_CLK1_OUT       , IEN | PTD | M7 },
	{ FREF_CLK2_OUT       , IEN | PTD | M7 },
	{ SYS_NIRQ1           , IEN | PTU | M0 },
	{ SYS_NIRQ2           , IEN | PTU | M0 },
	{ SYS_BOOT0           , IEN | PTD | M0 },
	{ SYS_BOOT1           , IEN | PTD | M0 },
	{ SYS_BOOT2           , IEN | PTD | M0 },
	{ SYS_BOOT3           , IEN | PTD | M0 },
	{ SYS_BOOT4           , IEN | PTD | M0 },
	{ SYS_BOOT5           , IEN | PTD | M0 },
	{ DPM_EMU0            , IEN | PTU | M0 },
	{ DPM_EMU1            , IEN | PTU | M3 },
	{ DPM_EMU2            , IEN | PTD | M7 },
	{ DPM_EMU3            ,             M5 },
	{ DPM_EMU4            ,             M5 },
	{ DPM_EMU5            ,             M5 },
	{ DPM_EMU6            ,             M5 },
	{ DPM_EMU7            ,             M5 },
	{ DPM_EMU8            ,             M5 },
	{ DPM_EMU9            ,             M5 },
	{ DPM_EMU10           ,             M5 },
	{ DPM_EMU11           ,             M5 },
	{ DPM_EMU12           ,             M5 },
	{ DPM_EMU13           ,             M5 },
	{ DPM_EMU14           ,             M5 },
	{ DPM_EMU15           ,             M5 },
	{ DPM_EMU16           ,             M5 },
	{ DPM_EMU17           ,             M5 },
	{ DPM_EMU18           ,             M5 },
	{ DPM_EMU19           ,             M5 },
	{ CSI22_DX2           , IEN | PTD | M7 },
	{ CSI22_DY2           , IEN | PTD | M7 },
};

static const struct pad_conf_entry wkup_padconf_array[] = {
	{ GPIO_WK0            , IEN | PTD | M7 },
	{ GPIO_WK1            , IEN | PTD | M7 },
	{ GPIO_WK2            , IEN | PTD | M7 },
	{ GPIO_WK3            , IEN | PTU | M7 },
	{ GPIO_WK4            , IEN | PTD | M7 },
	{ SR_SCL              , IEN       | M0 },
	{ SR_SDA              , IEN       | M0 },
	{ FREF_XTAL_IN        ,             M0 },
	{ FREF_SLICER_IN      ,             M0 },
	{ FREF_CLK_IOREQ      , IEN | PTD | M0 },
	{ FREF_CLK0_OUT       , IEN | PTD | M7 },
	{ FREF_CLK3_REQ       , IEN | PTD | M7 },
	{ FREF_CLK3_OUT       , IEN | PTD | M7 },
	{ FREF_CLK4_REQ       , IEN | PTU | M3 },
	{ FREF_CLK4_OUT       , IEN | PTD | M0 },
	{ SYS_32K             , IEN       | M0 },
	{ SYS_NRESPWRON       ,             M0 },
	{ SYS_NRESWARM        ,             M0 },
	{ SYS_PWR_REQ         , IEN | PTU | M0 },
	{ SYS_PWRON_RESET_OUT , IEN | PTD | M0 },
	{ SYS_BOOT6           , IEN       | M0 },
	{ SYS_BOOT7           , IEN       | M0 },
	{ JTAG_NTRST          , IEN | PTD | M0 },
	{ JTAG_TCK            , IEN | PTD | M0 },
	{ JTAG_RTCK           ,       PTD | M0 },
	{ JTAG_TMS_TMSC       , IEN       | M0 },
	{ JTAG_TDI            , IEN | PTU | M0 },
	{ JTAG_TDO            , IEN | PTU | M0 },
};

void archosg9_set_muxconf_regs(void)
{
	omap4_do_set_mux(OMAP44XX_CONTROL_PADCONF_CORE,
		core_padconf_array, ARRAY_SIZE(core_padconf_array));
	omap4_do_set_mux(OMAP44XX_CONTROL_PADCONF_WKUP,
		wkup_padconf_array, ARRAY_SIZE(wkup_padconf_array));

	/* gpio_wk7 is used for controlling TPS on 4460 */
	if (omap4_revision() >= OMAP4460_ES1_0) {
		/* Enable GPIO-1 clocks before TPS initialization */
		omap4_enable_gpio1_wup_clocks();
	}
}
