#ifndef _PPC_TYPES_H
#define _PPC_TYPES_H

#ifndef __ASSEMBLY__

typedef __signed__ char __s8;
typedef unsigned char __u8;

typedef __signed__ short __s16;
typedef unsigned short __u16;

typedef __signed__ int __s32;
typedef unsigned int __u32;

#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
typedef __signed__ long long __s64;
typedef unsigned long long __u64;
#endif

typedef struct {
	__u32 u[4];
} __attribute((aligned(16))) vector128;

#ifdef __KERNEL__
/*
 * These aren't exported outside the kernel to avoid name space clashes
 */
typedef signed char s8;
typedef unsigned char u8;

typedef signed short s16;
typedef unsigned short u16;

typedef signed int s32;
typedef unsigned int u32;

typedef signed long long s64;
typedef unsigned long long u64;

#include <asm-generic/bitsperlong.h>

#endif /* __KERNEL__ */
#endif /* __ASSEMBLY__ */

#endif
