#include <linux/types.h>
#include <input/keyboard.h>

#include <dt-bindings/input/input.h>
#include <readkey.h>

uint8_t keycode_bb_keys[NR_KEYS] = {
	[KEY_RESERVED] =	0xff,
	[KEY_ESC] =		0x1b,
	[KEY_1] =		'1',
	[KEY_2] =		'2',
	[KEY_3] =		'3',
	[KEY_4] =		'4',
	[KEY_5] =		'5',
	[KEY_6] =		'6',
	[KEY_7] =		'7',
	[KEY_8] =		'8',
	[KEY_9] =		'9',
	[KEY_0] =		'0',
	[KEY_MINUS] =		'-',
	[KEY_EQUAL] =		'=',
	[KEY_BACKSPACE] =	'\b',
	[KEY_TAB] =		'\t',
	[KEY_Q] =		'q',
	[KEY_W] =		'w',
	[KEY_E] =		'e',
	[KEY_R] =		'r',
	[KEY_T] =		't',
	[KEY_Y] =		'y',
	[KEY_U] =		'u',
	[KEY_I] =		'i',
	[KEY_O] =		'o',
	[KEY_P] =		'p',
	[KEY_LEFTBRACE] =	'[',
	[KEY_RIGHTBRACE] =	']',
	[KEY_ENTER] =		'\n',
	[KEY_A] =		'a',
	[KEY_S] =		's',
	[KEY_D] =		'd',
	[KEY_F] =		'f',
	[KEY_G] =		'g',
	[KEY_H] =		'h',
	[KEY_J] =		'j',
	[KEY_K] =		'k',
	[KEY_L] =		'l',
	[KEY_SEMICOLON] =	';',
	[KEY_APOSTROPHE] =	'`',
	[KEY_GRAVE] =		'^',
	[KEY_BACKSLASH] =	'\\',
	[KEY_Z] =		'z',
	[KEY_X] =		'x',
	[KEY_C] =		'c',
	[KEY_V] =		'v',
	[KEY_B] =		'b',
	[KEY_N] =		'n',
	[KEY_M] =		'm',
	[KEY_COMMA] =		',',
	[KEY_DOT] =		'.',
	[KEY_SLASH] =		'/',
	[KEY_SPACE] =		' ',
	[KEY_KP7] =		'7',
	[KEY_KP8] =		'8',
	[KEY_KP9] =		'9',
	[KEY_KPMINUS] =		'-',
	[KEY_KP4] =		'4',
	[KEY_KP5] =		'5',
	[KEY_KP6] =		'6',
	[KEY_KPPLUS] =		'+',
	[KEY_KP1] =		'1',
	[KEY_KP2] =		'2',
	[KEY_KP3] =		'3',
	[KEY_KP0] =		'0',
	[KEY_KPDOT] =		'.',
	[KEY_KPENTER] =		'\n',
	[KEY_HOME] =		BB_KEY_HOME,
	[KEY_UP] =		BB_KEY_UP,
	[KEY_PAGEUP] =		BB_KEY_PAGEUP,
	[KEY_LEFT] =		BB_KEY_LEFT,
	[KEY_RIGHT] =		BB_KEY_RIGHT,
	[KEY_END] =		BB_KEY_END,
	[KEY_DOWN] =		BB_KEY_DOWN,
	[KEY_PAGEDOWN] =	BB_KEY_PAGEDOWN,
	[KEY_INSERT] =		BB_KEY_INSERT,
	[KEY_DELETE] =		BB_KEY_DEL,
	[KEY_KPEQUAL] =		'=',
	[KEY_KPCOMMA] =		',',
};

uint8_t keycode_bb_shift_keys[NR_KEYS] = {
	[KEY_RESERVED] =	0xff,
	[KEY_ESC] =		0x1b,
	[KEY_1] =		'!',
	[KEY_2] =		'@',
	[KEY_3] =		'#',
	[KEY_4] =		'$',
	[KEY_5] =		'%',
	[KEY_6] =		'^',
	[KEY_7] =		'&',
	[KEY_8] =		'*',
	[KEY_9] =		'(',
	[KEY_0] =		')',
	[KEY_MINUS] =		'_',
	[KEY_EQUAL] =		'+',
	[KEY_BACKSPACE] =	'\b',
	[KEY_TAB] =		'\t',
	[KEY_Q] =		'Q',
	[KEY_W] =		'W',
	[KEY_E] =		'E',
	[KEY_R] =		'R',
	[KEY_T] =		'T',
	[KEY_Y] =		'Y',
	[KEY_U] =		'U',
	[KEY_I] =		'I',
	[KEY_O] =		'O',
	[KEY_P] =		'P',
	[KEY_LEFTBRACE] =	'{',
	[KEY_RIGHTBRACE] =	'}',
	[KEY_ENTER] =		'\n',
	[KEY_A] =		'A',
	[KEY_S] =		'S',
	[KEY_D] =		'D',
	[KEY_F] =		'F',
	[KEY_G] =		'G',
	[KEY_H] =		'H',
	[KEY_J] =		'J',
	[KEY_K] =		'K',
	[KEY_L] =		'L',
	[KEY_SEMICOLON] =	':',
	[KEY_APOSTROPHE] =	'~',
	[KEY_GRAVE] =		'^',
	[KEY_BACKSLASH] =	'|',
	[KEY_Z] =		'Z',
	[KEY_X] =		'X',
	[KEY_C] =		'C',
	[KEY_V] =		'V',
	[KEY_B] =		'B',
	[KEY_N] =		'N',
	[KEY_M] =		'M',
	[KEY_COMMA] =		'<',
	[KEY_DOT] =		'>',
	[KEY_SLASH] =		'?',
	[KEY_SPACE] =		' ',
	[KEY_KP7] =		'7',
	[KEY_KP8] =		'8',
	[KEY_KP9] =		'9',
	[KEY_KP4] =		'4',
	[KEY_KP5] =		'5',
	[KEY_KP6] =		'6',
	[KEY_KPPLUS] =		'+',
	[KEY_KP1] =		'1',
	[KEY_KP2] =		'2',
	[KEY_KP3] =		'3',
	[KEY_KP0] =		'4',
	[KEY_KPDOT] =		'.',
	[KEY_KPENTER] =		'\n',
	[KEY_KPSLASH] =		'/',
	[KEY_HOME] =		BB_KEY_HOME,
	[KEY_UP] =		BB_KEY_UP,
	[KEY_PAGEUP] =		BB_KEY_PAGEUP,
	[KEY_LEFT] =		BB_KEY_LEFT,
	[KEY_RIGHT] =		BB_KEY_RIGHT,
	[KEY_END] =		BB_KEY_END,
	[KEY_DOWN] =		BB_KEY_DOWN,
	[KEY_PAGEDOWN] =	BB_KEY_PAGEDOWN,
	[KEY_INSERT] =		BB_KEY_INSERT,
	[KEY_DELETE] =		BB_KEY_DEL7,
	[KEY_KPEQUAL] =		'=',
	[KEY_KPCOMMA] =		',',
};
