/*
 * (c) 2009 Pengutronix, Sascha Hauer <s.hauer@pengutronix.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __ASM_ARCH_MX35_REGS_H
#define __ASM_ARCH_MX35_REGS_H

#include <sizes.h>

#define MX35_IRAM_BASE_ADDR		0x10000000	/* internal ram */
#define MX35_IRAM_SIZE			SZ_128K

#define MX35_L2CC_BASE_ADDR		0x30000000
#define MX35_L2CC_SIZE			SZ_1M

#define MX35_AIPS1_BASE_ADDR		0x43f00000
#define MX35_AIPS1_SIZE			SZ_1M
#define MX35_MAX_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x04000)
#define MX35_EVTMON_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x08000)
#define MX35_CLKCTL_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x0c000)
#define MX35_ETB_SLOT4_BASE_ADDR		(MX35_AIPS1_BASE_ADDR + 0x10000)
#define MX35_ETB_SLOT5_BASE_ADDR		(MX35_AIPS1_BASE_ADDR + 0x14000)
#define MX35_ECT_CTIO_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x18000)
#define MX35_I2C1_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x80000)
#define MX35_I2C3_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x84000)
#define MX35_UART1_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x90000)
#define MX35_UART2_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x94000)
#define MX35_I2C2_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x98000)
#define MX35_OWIRE_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0x9c000)
#define MX35_SSI1_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0xa0000)
#define MX35_CSPI1_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0xa4000)
#define MX35_KPP_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0xa8000)
#define MX35_IOMUXC_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0xac000)
#define MX35_ECT_IP1_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0xb8000)
#define MX35_ECT_IP2_BASE_ADDR			(MX35_AIPS1_BASE_ADDR + 0xbc000)

#define MX35_SPBA0_BASE_ADDR		0x50000000
#define MX35_SPBA0_SIZE			SZ_1M
#define MX35_UART3_BASE_ADDR			(MX35_SPBA0_BASE_ADDR + 0x0c000)
#define MX35_CSPI2_BASE_ADDR			(MX35_SPBA0_BASE_ADDR + 0x10000)
#define MX35_SSI2_BASE_ADDR			(MX35_SPBA0_BASE_ADDR + 0x14000)
#define MX35_ATA_BASE_ADDR			(MX35_SPBA0_BASE_ADDR + 0x20000)
#define MX35_MSHC1_BASE_ADDR			(MX35_SPBA0_BASE_ADDR + 0x24000)
#define MX35_FEC_BASE_ADDR		0x50038000
#define MX35_SPBA_CTRL_BASE_ADDR		(MX35_SPBA0_BASE_ADDR + 0x3c000)

#define MX35_AIPS2_BASE_ADDR		0x53f00000
#define MX35_AIPS2_SIZE			SZ_1M
#define MX35_CCM_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0x80000)
#define MX35_GPT1_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0x90000)
#define MX35_EPIT1_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0x94000)
#define MX35_EPIT2_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0x98000)
#define MX35_GPIO3_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xa4000)
#define MX35_SCC_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xac000)
#define MX35_RNGA_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xb0000)
#define MX35_ESDHC1_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xb4000)
#define MX35_ESDHC2_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xb8000)
#define MX35_ESDHC3_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xbc000)
#define MX35_IPU_CTRL_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xc0000)
#define MX35_AUDMUX_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xc4000)
#define MX35_GPIO1_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xcc000)
#define MX35_GPIO2_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xd0000)
#define MX35_SDMA_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xd4000)
#define MX35_RTC_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xd8000)
#define MX35_WDOG_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xdc000)
#define MX35_PWM_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xe0000)
#define MX35_CAN1_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xe4000)
#define MX35_CAN2_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xe8000)
#define MX35_RTIC_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xec000)
#define MX35_IIM_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xf0000)
#define MX35_USB_BASE_ADDR			(MX35_AIPS2_BASE_ADDR + 0xf4000)
#define MX35_USB_OTG_BASE_ADDR			(MX35_USB_BASE_ADDR + 0x0000)

/*
 * The Reference Manual (IMX35RM, Rev. 2, 3/2009) claims an offset of 0x200 for
 * HS.  When host support was implemented only a preliminary document was
 * available, which told 0x400.  This works fine.
 */
#define MX35_USB_HS_BASE_ADDR			(MX35_USB_BASE_ADDR + 0x0400)

#define MX35_ROMP_BASE_ADDR		0x60000000
#define MX35_ROMP_SIZE			SZ_1M

#define MX35_AVIC_BASE_ADDR		0x68000000
#define MX35_AVIC_SIZE			SZ_1M

/*
 * Memory regions and CS
 */
#define MX35_IPU_MEM_BASE_ADDR		0x70000000
#define MX35_CSD0_BASE_ADDR		0x80000000
#define MX35_CSD1_BASE_ADDR		0x90000000

#define MX35_CS0_BASE_ADDR		0xa0000000
#define MX35_CS1_BASE_ADDR		0xa8000000
#define MX35_CS2_BASE_ADDR		0xb0000000
#define MX35_CS3_BASE_ADDR		0xb2000000

#define MX35_CS4_BASE_ADDR		0xb4000000
#define MX35_CS4_SIZE			SZ_32M

#define MX35_CS5_BASE_ADDR		0xb6000000
#define MX35_CS5_SIZE			SZ_32M

/*
 * NAND, SDRAM, WEIM, M3IF, EMI controllers
 */
#define MX35_X_MEMC_BASE_ADDR		0xb8000000
#define MX35_X_MEMC_SIZE		SZ_64K
#define MX35_ESDCTL_BASE_ADDR			(MX35_X_MEMC_BASE_ADDR + 0x1000)
#define MX35_WEIM_BASE_ADDR			(MX35_X_MEMC_BASE_ADDR + 0x2000)
#define MX35_M3IF_BASE_ADDR			(MX35_X_MEMC_BASE_ADDR + 0x3000)
#define MX35_EMI_CTL_BASE_ADDR			(MX35_X_MEMC_BASE_ADDR + 0x4000)
#define MX35_PCMCIA_CTL_BASE_ADDR		MX35_EMI_CTL_BASE_ADDR

#define MX35_NFC_BASE_ADDR		0xbb000000
#define MX35_PCMCIA_MEM_BASE_ADDR	0xbc000000

/*
 * Clock Controller Module (CCM)
 */
#define MX35_CCM_CCMR	0x00
#define MX35_CCM_PDR0	0x04
#define MX35_CCM_PDR1	0x08
#define MX35_CCM_PDR2	0x0C
#define MX35_CCM_PDR3	0x10
#define MX35_CCM_PDR4	0x14
#define MX35_CCM_RCSR	0x18
#define MX35_CCM_MPCTL	0x1C
#define MX35_CCM_PPCTL	0x20
#define MX35_CCM_ACMR	0x24
#define MX35_CCM_COSR	0x28
#define MX35_CCM_CGR0	0x2C
#define MX35_CCM_CGR1	0x30
#define MX35_CCM_CGR2	0x34
#define MX35_CCM_CGR3	0x38

#define MX35_CCM_CGR0_CSPI1_SHIFT	10
#define MX35_CCM_CGR1_FEC_SHIFT	0
#define MX35_CCM_CGR1_I2C1_SHIFT	10
#define MX35_CCM_CGR1_SDHC1_SHIFT	26
#define MX35_CCM_CGR2_UART2_SHIFT	18
#define MX35_CCM_CGR2_USB_SHIFT	22

#define MX35_CCM_RCSR_MEM_CTRL_SHIFT		25
#define MX35_CCM_RCSR_MEM_TYPE_SHIFT		23

#define MX35_PDR0_AUTO_MUX_DIV(x)	(((x) & 0x7) << 9)
#define MX35_PDR0_CCM_PER_AHB(x)	(((x) & 0x7) << 12)
#define MX35_PDR0_CON_MUX_DIV(x)	(((x) & 0xf) << 16)
#define MX35_PDR0_HSP_PODF(x)		(((x) & 0x3) << 20)
#define MX35_PDR0_AUTO_CON		(1 << 0)
#define MX35_PDR0_PER_SEL		(1 << 26)

#endif /* __ASM_ARCH_MX35_REGS_H */
