/*
 * Copyright (C) 2013 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __DTS_IMX51_PINGRP_H
#define __DTS_IMX51_PINGRP_H

#include "imx51-pinfunc.h"

#define MX51_AUDMUX_PINGRP1 \
	MX51_PAD_AUD3_BB_TXD__AUD3_TXD			0x80000000 \
	MX51_PAD_AUD3_BB_RXD__AUD3_RXD			0x80000000 \
	MX51_PAD_AUD3_BB_CK__AUD3_TXC			0x80000000 \
	MX51_PAD_AUD3_BB_FS__AUD3_TXFS			0x80000000

#define MX51_FEC_PINGRP1 \
	MX51_PAD_EIM_EB2__FEC_MDIO			0x80000000 \
	MX51_PAD_EIM_EB3__FEC_RDATA1			0x80000000 \
	MX51_PAD_EIM_CS2__FEC_RDATA2			0x80000000 \
	MX51_PAD_EIM_CS3__FEC_RDATA3			0x80000000 \
	MX51_PAD_EIM_CS4__FEC_RX_ER			0x80000000 \
	MX51_PAD_EIM_CS5__FEC_CRS			0x80000000 \
	MX51_PAD_NANDF_RB2__FEC_COL			0x80000000 \
	MX51_PAD_NANDF_RB3__FEC_RX_CLK			0x80000000 \
	MX51_PAD_NANDF_D9__FEC_RDATA0			0x80000000 \
	MX51_PAD_NANDF_D8__FEC_TDATA0			0x80000000 \
	MX51_PAD_NANDF_CS2__FEC_TX_ER			0x80000000 \
	MX51_PAD_NANDF_CS3__FEC_MDC			0x80000000 \
	MX51_PAD_NANDF_CS4__FEC_TDATA1			0x80000000 \
	MX51_PAD_NANDF_CS5__FEC_TDATA2			0x80000000 \
	MX51_PAD_NANDF_CS6__FEC_TDATA3			0x80000000 \
	MX51_PAD_NANDF_CS7__FEC_TX_EN			0x80000000 \
	MX51_PAD_NANDF_RDY_INT__FEC_TX_CLK		0x80000000

#define MX51_FEC_PINGRP2 \
	MX51_PAD_DI_GP3__FEC_TX_ER			0x80000000 \
	MX51_PAD_DI2_PIN4__FEC_CRS			0x80000000 \
	MX51_PAD_DI2_PIN2__FEC_MDC			0x80000000 \
	MX51_PAD_DI2_PIN3__FEC_MDIO			0x80000000 \
	MX51_PAD_DI2_DISP_CLK__FEC_RDATA1		0x80000000 \
	MX51_PAD_DI_GP4__FEC_RDATA2			0x80000000 \
	MX51_PAD_DISP2_DAT0__FEC_RDATA3			0x80000000 \
	MX51_PAD_DISP2_DAT1__FEC_RX_ER			0x80000000 \
	MX51_PAD_DISP2_DAT6__FEC_TDATA1			0x80000000 \
	MX51_PAD_DISP2_DAT7__FEC_TDATA2			0x80000000 \
	MX51_PAD_DISP2_DAT8__FEC_TDATA3			0x80000000 \
	MX51_PAD_DISP2_DAT9__FEC_TX_EN			0x80000000 \
	MX51_PAD_DISP2_DAT10__FEC_COL			0x80000000 \
	MX51_PAD_DISP2_DAT11__FEC_RX_CLK		0x80000000 \
	MX51_PAD_DISP2_DAT12__FEC_RX_DV			0x80000000 \
	MX51_PAD_DISP2_DAT13__FEC_TX_CLK		0x80000000 \
	MX51_PAD_DISP2_DAT14__FEC_RDATA0		0x80000000 \
	MX51_PAD_DISP2_DAT15__FEC_TDATA0		0x80000000

#define MX51_ECSPI1_PINGRP1 \
	MX51_PAD_CSPI1_MISO__ECSPI1_MISO		0x185 \
	MX51_PAD_CSPI1_MOSI__ECSPI1_MOSI		0x185 \
	MX51_PAD_CSPI1_SCLK__ECSPI1_SCLK		0x185

#define MX51_ECSPI2_PINGRP1 \
	MX51_PAD_NANDF_RB3__ECSPI2_MISO			0x185 \
	MX51_PAD_NANDF_D15__ECSPI2_MOSI			0x185 \
	MX51_PAD_NANDF_RB2__ECSPI2_SCLK			0x185

#define MX51_ESDHC1_PINGRP1 \
	MX51_PAD_SD1_CMD__SD1_CMD			0x400020d5 \
	MX51_PAD_SD1_CLK__SD1_CLK			0x20d5 \
	MX51_PAD_SD1_DATA0__SD1_DATA0			0x20d5 \
	MX51_PAD_SD1_DATA1__SD1_DATA1			0x20d5 \
	MX51_PAD_SD1_DATA2__SD1_DATA2			0x20d5 \
	MX51_PAD_SD1_DATA3__SD1_DATA3			0x20d5

#define MX51_ESDHC2_PINGRP1 \
	MX51_PAD_SD2_CMD__SD2_CMD			0x400020d5 \
	MX51_PAD_SD2_CLK__SD2_CLK			0x20d5 \
	MX51_PAD_SD2_DATA0__SD2_DATA0			0x20d5 \
	MX51_PAD_SD2_DATA1__SD2_DATA1			0x20d5 \
	MX51_PAD_SD2_DATA2__SD2_DATA2			0x20d5 \
	MX51_PAD_SD2_DATA3__SD2_DATA3			0x20d5

#define MX51_I2C1_PINGRP1 \
	MX51_PAD_SD2_CMD__I2C1_SCL			0x400001ed \
	MX51_PAD_SD2_CLK__I2C1_SDA			0x400001ed

#define MX51_I2C2_PINGRP1 \
	MX51_PAD_KEY_COL4__I2C2_SCL			0x400001ed \
	MX51_PAD_KEY_COL5__I2C2_SDA			0x400001ed

#define MX51_I2C2_PINGRP2 \
	MX51_PAD_EIM_D27__I2C2_SCL			0x400001ed \
	MX51_PAD_EIM_D24__I2C2_SDA			0x400001ed

#define MX51_I2C2_PINGRP3 \
	MX51_PAD_GPIO1_2__I2C2_SCL			0x400001ed \
	MX51_PAD_GPIO1_3__I2C2_SDA			0x400001ed

#define MX51_IPU_DISP1_PINGRP1 \
	MX51_PAD_DISP1_DAT0__DISP1_DAT0			0x5 \
	MX51_PAD_DISP1_DAT1__DISP1_DAT1			0x5 \
	MX51_PAD_DISP1_DAT2__DISP1_DAT2			0x5 \
	MX51_PAD_DISP1_DAT3__DISP1_DAT3			0x5 \
	MX51_PAD_DISP1_DAT4__DISP1_DAT4			0x5 \
	MX51_PAD_DISP1_DAT5__DISP1_DAT5			0x5 \
	MX51_PAD_DISP1_DAT6__DISP1_DAT6			0x5 \
	MX51_PAD_DISP1_DAT7__DISP1_DAT7			0x5 \
	MX51_PAD_DISP1_DAT8__DISP1_DAT8			0x5 \
	MX51_PAD_DISP1_DAT9__DISP1_DAT9			0x5 \
	MX51_PAD_DISP1_DAT10__DISP1_DAT10		0x5 \
	MX51_PAD_DISP1_DAT11__DISP1_DAT11		0x5 \
	MX51_PAD_DISP1_DAT12__DISP1_DAT12		0x5 \
	MX51_PAD_DISP1_DAT13__DISP1_DAT13		0x5 \
	MX51_PAD_DISP1_DAT14__DISP1_DAT14		0x5 \
	MX51_PAD_DISP1_DAT15__DISP1_DAT15		0x5 \
	MX51_PAD_DISP1_DAT16__DISP1_DAT16		0x5 \
	MX51_PAD_DISP1_DAT17__DISP1_DAT17		0x5 \
	MX51_PAD_DISP1_DAT18__DISP1_DAT18		0x5 \
	MX51_PAD_DISP1_DAT19__DISP1_DAT19		0x5 \
	MX51_PAD_DISP1_DAT20__DISP1_DAT20		0x5 \
	MX51_PAD_DISP1_DAT21__DISP1_DAT21		0x5 \
	MX51_PAD_DISP1_DAT22__DISP1_DAT22		0x5 \
	MX51_PAD_DISP1_DAT23__DISP1_DAT23		0x5 \
	MX51_PAD_DI1_PIN2__DI1_PIN2			0x5 \
	MX51_PAD_DI1_PIN3__DI1_PIN3			0x5

#define MX51_IPU_DISP2_PINGRP1 \
	MX51_PAD_DISP2_DAT0__DISP2_DAT0			0x5 \
	MX51_PAD_DISP2_DAT1__DISP2_DAT1			0x5 \
	MX51_PAD_DISP2_DAT2__DISP2_DAT2			0x5 \
	MX51_PAD_DISP2_DAT3__DISP2_DAT3			0x5 \
	MX51_PAD_DISP2_DAT4__DISP2_DAT4			0x5 \
	MX51_PAD_DISP2_DAT5__DISP2_DAT5			0x5 \
	MX51_PAD_DISP2_DAT6__DISP2_DAT6			0x5 \
	MX51_PAD_DISP2_DAT7__DISP2_DAT7			0x5 \
	MX51_PAD_DISP2_DAT8__DISP2_DAT8			0x5 \
	MX51_PAD_DISP2_DAT9__DISP2_DAT9			0x5 \
	MX51_PAD_DISP2_DAT10__DISP2_DAT10		0x5 \
	MX51_PAD_DISP2_DAT11__DISP2_DAT11		0x5 \
	MX51_PAD_DISP2_DAT12__DISP2_DAT12		0x5 \
	MX51_PAD_DISP2_DAT13__DISP2_DAT13		0x5 \
	MX51_PAD_DISP2_DAT14__DISP2_DAT14		0x5 \
	MX51_PAD_DISP2_DAT15__DISP2_DAT15		0x5 \
	MX51_PAD_DI2_PIN2__DI2_PIN2			0x5 \
	MX51_PAD_DI2_PIN3__DI2_PIN3			0x5 \
	MX51_PAD_DI2_DISP_CLK__DI2_DISP_CLK		0x5 \
	MX51_PAD_DI_GP4__DI2_PIN15			0x5

#define MX51_KPP_PINGRP1 \
	MX51_PAD_KEY_ROW0__KEY_ROW0			0xe0 \
	MX51_PAD_KEY_ROW1__KEY_ROW1			0xe0 \
	MX51_PAD_KEY_ROW2__KEY_ROW2			0xe0 \
	MX51_PAD_KEY_ROW3__KEY_ROW3			0xe0 \
	MX51_PAD_KEY_COL0__KEY_COL0			0xe8 \
	MX51_PAD_KEY_COL1__KEY_COL1			0xe8 \
	MX51_PAD_KEY_COL2__KEY_COL2			0xe8 \
	MX51_PAD_KEY_COL3__KEY_COL3			0xe8

#define MX51_PATA_PINGRP1 \
	MX51_PAD_NANDF_WE_B__PATA_DIOW			0x2004 \
	MX51_PAD_NANDF_RE_B__PATA_DIOR			0x2004 \
	MX51_PAD_NANDF_ALE__PATA_BUFFER_EN		0x2004 \
	MX51_PAD_NANDF_CLE__PATA_RESET_B		0x2004 \
	MX51_PAD_NANDF_WP_B__PATA_DMACK			0x2004 \
	MX51_PAD_NANDF_RB0__PATA_DMARQ			0x2004 \
	MX51_PAD_NANDF_RB1__PATA_IORDY			0x2004 \
	MX51_PAD_GPIO_NAND__PATA_INTRQ			0x2004 \
	MX51_PAD_NANDF_CS2__PATA_CS_0			0x2004 \
	MX51_PAD_NANDF_CS3__PATA_CS_1			0x2004 \
	MX51_PAD_NANDF_CS4__PATA_DA_0			0x2004 \
	MX51_PAD_NANDF_CS5__PATA_DA_1			0x2004 \
	MX51_PAD_NANDF_CS6__PATA_DA_2			0x2004 \
	MX51_PAD_NANDF_D15__PATA_DATA15			0x2004 \
	MX51_PAD_NANDF_D14__PATA_DATA14			0x2004 \
	MX51_PAD_NANDF_D13__PATA_DATA13			0x2004 \
	MX51_PAD_NANDF_D12__PATA_DATA12			0x2004 \
	MX51_PAD_NANDF_D11__PATA_DATA11			0x2004 \
	MX51_PAD_NANDF_D10__PATA_DATA10			0x2004 \
	MX51_PAD_NANDF_D9__PATA_DATA9			0x2004 \
	MX51_PAD_NANDF_D8__PATA_DATA8			0x2004 \
	MX51_PAD_NANDF_D7__PATA_DATA7			0x2004 \
	MX51_PAD_NANDF_D6__PATA_DATA6			0x2004 \
	MX51_PAD_NANDF_D5__PATA_DATA5			0x2004 \
	MX51_PAD_NANDF_D4__PATA_DATA4			0x2004 \
	MX51_PAD_NANDF_D3__PATA_DATA3			0x2004 \
	MX51_PAD_NANDF_D2__PATA_DATA2			0x2004 \
	MX51_PAD_NANDF_D1__PATA_DATA1			0x2004 \
	MX51_PAD_NANDF_D0__PATA_DATA0			0x2004

#define MX51_UART1_PINGRP1 \
	MX51_PAD_UART1_RXD__UART1_RXD			0x1c5 \
	MX51_PAD_UART1_TXD__UART1_TXD			0x1c5

#define MX51_UART1_RTSCTS_PINGRP1 \
	MX51_PAD_UART1_RTS__UART1_RTS			0x1c5 \
	MX51_PAD_UART1_CTS__UART1_CTS			0x1c5

#define MX51_UART2_PINGRP1 \
	MX51_PAD_UART2_RXD__UART2_RXD			0x1c5 \
	MX51_PAD_UART2_TXD__UART2_TXD			0x1c5

#define MX51_UART3_PINGRP1 \
	MX51_PAD_EIM_D25__UART3_RXD			0x1c5 \
	MX51_PAD_EIM_D26__UART3_TXD			0x1c5

#define MX51_UART3_RTSCTS_PINGRP1 \
	MX51_PAD_EIM_D27__UART3_RTS			0x1c5 \
	MX51_PAD_EIM_D24__UART3_CTS			0x1c5

#define MX51_UART3_PINGRP2 \
	MX51_PAD_UART3_RXD__UART3_RXD			0x1c5 \
	MX51_PAD_UART3_TXD__UART3_TXD			0x1c5

#define MX51_UART3_RTSCTS_PINGRP2 \
	MX51_PAD_KEY_COL4__UART3_RTS			0x1c5 \
	MX51_PAD_KEY_COL5__UART3_CTS			0x1c5

#define MX51_USBH1_PINGRP1 \
	MX51_PAD_USBH1_DATA0__USBH1_DATA0		0x1e5 \
	MX51_PAD_USBH1_DATA1__USBH1_DATA1		0x1e5 \
	MX51_PAD_USBH1_DATA2__USBH1_DATA2		0x1e5 \
	MX51_PAD_USBH1_DATA3__USBH1_DATA3		0x1e5 \
	MX51_PAD_USBH1_DATA4__USBH1_DATA4		0x1e5 \
	MX51_PAD_USBH1_DATA5__USBH1_DATA5		0x1e5 \
	MX51_PAD_USBH1_DATA6__USBH1_DATA6		0x1e5 \
	MX51_PAD_USBH1_DATA7__USBH1_DATA7		0x1e5 \
	MX51_PAD_USBH1_CLK__USBH1_CLK			0x1e5 \
	MX51_PAD_USBH1_DIR__USBH1_DIR			0x1e5 \
	MX51_PAD_USBH1_NXT__USBH1_NXT			0x1e5 \
	MX51_PAD_USBH1_STP__USBH1_STP			0x1e5

#define MX51_USBH2_PINGRP1 \
	MX51_PAD_EIM_D16__USBH2_DATA0			0x1e5 \
	MX51_PAD_EIM_D17__USBH2_DATA1			0x1e5 \
	MX51_PAD_EIM_D18__USBH2_DATA2			0x1e5 \
	MX51_PAD_EIM_D19__USBH2_DATA3			0x1e5 \
	MX51_PAD_EIM_D20__USBH2_DATA4			0x1e5 \
	MX51_PAD_EIM_D21__USBH2_DATA5			0x1e5 \
	MX51_PAD_EIM_D22__USBH2_DATA6			0x1e5 \
	MX51_PAD_EIM_D23__USBH2_DATA7			0x1e5 \
	MX51_PAD_EIM_A24__USBH2_CLK			0x1e5 \
	MX51_PAD_EIM_A25__USBH2_DIR			0x1e5 \
	MX51_PAD_EIM_A27__USBH2_NXT			0x1e5 \
	MX51_PAD_EIM_A26__USBH2_STP			0x1e5

#endif /* __DTS_IMX51_PINGRP_H */
