/*
 * Copyright 2013 Markus Pargmann <mpa@pengutronix.de>, Pengutronix
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
#ifndef __DTS_IMX27_PINGRP_H
#define __DTS_IMX27_PINGRP_H

#include "imx27-pinfunc.h"

#define MX27_CSPI1_PINGRP1 \
	MX27_PAD_CSPI1_MISO__CSPI1_MISO 0x0 \
	MX27_PAD_CSPI1_MOSI__CSPI1_MOSI 0x0 \
	MX27_PAD_CSPI1_SCLK__CSPI1_SCLK 0x0

#define MX27_CSPI2_PINGRP1 \
	MX27_PAD_CSPI2_MISO__CSPI2_MISO 0x0 \
	MX27_PAD_CSPI2_MOSI__CSPI2_MOSI 0x0 \
	MX27_PAD_CSPI2_SCLK__CSPI2_SCLK 0x0

#define MX27_CSPI3_PINGRP1 \
	MX27_PAD_SD1_CLK__CSPI3_SCLK 0x0 \
	MX27_PAD_SD1_D0__CSPI3_MISO 0x0 \
	MX27_PAD_SD1_CMD__CSPI3_MOSI 0x0

#define MX27_FB_PINGRP1 \
	MX27_PAD_CLS__CLS 0x0 \
	MX27_PAD_CONTRAST__CONTRAST 0x0 \
	MX27_PAD_LD0__LD0 0x0 \
	MX27_PAD_LD1__LD1 0x0 \
	MX27_PAD_LD2__LD2 0x0 \
	MX27_PAD_LD3__LD3 0x0 \
	MX27_PAD_LD4__LD4 0x0 \
	MX27_PAD_LD5__LD5 0x0 \
	MX27_PAD_LD6__LD6 0x0 \
	MX27_PAD_LD7__LD7 0x0 \
	MX27_PAD_LD8__LD8 0x0 \
	MX27_PAD_LD9__LD9 0x0 \
	MX27_PAD_LD10__LD10 0x0 \
	MX27_PAD_LD11__LD11 0x0 \
	MX27_PAD_LD12__LD12 0x0 \
	MX27_PAD_LD13__LD13 0x0 \
	MX27_PAD_LD14__LD14 0x0 \
	MX27_PAD_LD15__LD15 0x0 \
	MX27_PAD_LD16__LD16 0x0 \
	MX27_PAD_LD17__LD17 0x0 \
	MX27_PAD_LSCLK__LSCLK 0x0 \
	MX27_PAD_OE_ACD__OE_ACD 0x0 \
	MX27_PAD_PS__PS 0x0 \
	MX27_PAD_REV__REV 0x0 \
	MX27_PAD_SPL_SPR__SPL_SPR 0x0 \
	MX27_PAD_HSYNC__HSYNC 0x0 \
	MX27_PAD_VSYNC__VSYNC 0x0

#define MX27_FEC1_PINGRP1 \
	MX27_PAD_SD3_CMD__FEC_TXD0 0x0 \
	MX27_PAD_SD3_CLK__FEC_TXD1 0x0 \
	MX27_PAD_ATA_DATA0__FEC_TXD2 0x0 \
	MX27_PAD_ATA_DATA1__FEC_TXD3 0x0 \
	MX27_PAD_ATA_DATA2__FEC_RX_ER 0x0 \
	MX27_PAD_ATA_DATA3__FEC_RXD1 0x0 \
	MX27_PAD_ATA_DATA4__FEC_RXD2 0x0 \
	MX27_PAD_ATA_DATA5__FEC_RXD3 0x0 \
	MX27_PAD_ATA_DATA6__FEC_MDIO 0x0 \
	MX27_PAD_ATA_DATA7__FEC_MDC 0x0 \
	MX27_PAD_ATA_DATA8__FEC_CRS 0x0 \
	MX27_PAD_ATA_DATA9__FEC_TX_CLK 0x0 \
	MX27_PAD_ATA_DATA10__FEC_RXD0 0x0 \
	MX27_PAD_ATA_DATA11__FEC_RX_DV 0x0 \
	MX27_PAD_ATA_DATA12__FEC_RX_CLK 0x0 \
	MX27_PAD_ATA_DATA13__FEC_COL 0x0 \
	MX27_PAD_ATA_DATA14__FEC_TX_ER 0x0 \
	MX27_PAD_ATA_DATA15__FEC_TX_EN 0x0

#define MX27_I2C1_PINGRP1 \
	MX27_PAD_I2C_DATA__I2C_DATA 0x0 \
	MX27_PAD_I2C_CLK__I2C_CLK 0x0

#define MX27_I2C2_PINGRP1 \
	MX27_PAD_I2C2_SDA__I2C2_SDA 0x0 \
	MX27_PAD_I2C2_SCL__I2C2_SCL 0x0

#define MX27_NFC_PINGRP1 \
	MX27_PAD_NFRB__NFRB 0x0 \
	MX27_PAD_NFCLE__NFCLE 0x0 \
	MX27_PAD_NFWP_B__NFWP_B 0x0 \
	MX27_PAD_NFCE_B__NFCE_B 0x0 \
	MX27_PAD_NFALE__NFALE 0x0 \
	MX27_PAD_NFRE_B__NFRE_B 0x0 \
	MX27_PAD_NFWE_B__NFWE_B 0x0

#define MX27_OWIRE1_PINGRP1 \
	MX27_PAD_RTCK__OWIRE 0x0

#define MX27_PWM_PINGRP1 \
	MX27_PAD_PWMO__PWMO 0x0

#define MX27_SDHC1_PINGRP1 \
	MX27_PAD_SD1_CLK__SD1_CLK 0x0 \
	MX27_PAD_SD1_CMD__SD1_CMD 0x0 \
	MX27_PAD_SD1_D0__SD1_D0 0x0 \
	MX27_PAD_SD1_D1__SD1_D1 0x0 \
	MX27_PAD_SD1_D2__SD1_D2 0x0 \
	MX27_PAD_SD1_D3__SD1_D3 0x0

#define MX27_SDHC2_PINGRP1 \
	MX27_PAD_SD2_CLK__SD2_CLK 0x0 \
	MX27_PAD_SD2_CMD__SD2_CMD 0x0 \
	MX27_PAD_SD2_D0__SD2_D0 0x0 \
	MX27_PAD_SD2_D1__SD2_D1 0x0 \
	MX27_PAD_SD2_D2__SD2_D2 0x0 \
	MX27_PAD_SD2_D3__SD2_D3 0x0

#define MX27_SDHC3_PINGRP1 \
	MX27_PAD_SD3_CLK__SD3_CLK 0x0 \
	MX27_PAD_SD3_CMD__SD3_CMD 0x0 \
	MX27_PAD_SD3_D0__SD3_D0 0x0 \
	MX27_PAD_SD3_D1__SD3_D1 0x0 \
	MX27_PAD_SD3_D2__SD3_D2 0x0 \
	MX27_PAD_SD3_D3__SD3_D3 0x0

#define MX27_UART1_PINGRP1 \
	MX27_PAD_UART1_TXD__UART1_TXD 0x0 \
	MX27_PAD_UART1_RXD__UART1_RXD 0x0

#define MX27_UART1_RTSCTS_PINGRP1 \
	MX27_PAD_UART1_CTS__UART1_CTS 0x0 \
	MX27_PAD_UART1_RTS__UART1_RTS 0x0

#define MX27_UART2_PINGRP1 \
	MX27_PAD_UART2_TXD__UART2_TXD 0x0 \
	MX27_PAD_UART2_RXD__UART2_RXD 0x0

#define MX27_UART2_RTSCTS_PINGRP1 \
	MX27_PAD_UART2_CTS__UART2_CTS 0x0 \
	MX27_PAD_UART2_RTS__UART2_RTS 0x0

#define MX27_UART3_PINGRP1 \
	MX27_PAD_UART3_TXD__UART3_TXD 0x0 \
	MX27_PAD_UART3_RXD__UART3_RXD 0x0

#define MX27_UART3_RTSCTS_PINGRP1 \
	MX27_PAD_UART3_CTS__UART3_CTS 0x0 \
	MX27_PAD_UART3_RTS__UART3_RTS 0x0

#endif /* __DTS_IMX27_PINGRP_H */
