/*
 * Copyright (C) 2011 Sascha Hauer, Pengutronix
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 */

#include <common.h>
#include <environment.h>
#include <fcntl.h>
#include <fec.h>
#include <fs.h>
#include <init.h>
#include <nand.h>
#include <net.h>
#include <partition.h>
#include <sizes.h>
#include <gpio.h>
#include <mci.h>
#include <io.h>

#include <asm/armlinux.h>
#include <asm/mmu.h>
#include <generated/mach-types.h>

#include <mach/imx53-regs.h>
#include <mach/iomux-mx53.h>
#include <mach/devices-imx53.h>
#include <mach/generic.h>
#include <mach/imx-nand.h>
#include <mach/iim.h>
#include <mach/imx5.h>

static struct fec_platform_data fec_info = {
	.xcv_type = PHY_INTERFACE_MODE_RMII,
};

static iomux_v3_cfg_t tqma53_pads[] = {
	MX53_PAD_KEY_ROW1__AUDMUX_AUD5_RXD,
	MX53_PAD_KEY_COL0__AUDMUX_AUD5_TXC,
	MX53_PAD_KEY_ROW0__AUDMUX_AUD5_TXD,
	MX53_PAD_KEY_COL1__AUDMUX_AUD5_TXFS,
	MX53_PAD_KEY_ROW2__CAN1_RXCAN,
	MX53_PAD_KEY_COL2__CAN1_TXCAN,
	MX53_PAD_KEY_ROW4__CAN2_RXCAN,
	MX53_PAD_KEY_COL4__CAN2_TXCAN,
	MX53_PAD_GPIO_19__CCM_CLKO,
	MX53_PAD_NANDF_CS2__CCM_CSI0_MCLK,
	MX53_PAD_SD1_DATA0__CSPI_MISO,
	MX53_PAD_SD1_CMD__CSPI_MOSI,
	MX53_PAD_SD1_CLK__CSPI_SCLK,
	MX53_PAD_SD1_DATA1__CSPI_SS0,
	MX53_PAD_SD1_DATA2__CSPI_SS1,
	MX53_PAD_SD1_DATA3__CSPI_SS2,
	MX53_PAD_EIM_D17__ECSPI1_MISO,
	MX53_PAD_EIM_D18__ECSPI1_MOSI,
	MX53_PAD_EIM_D16__ECSPI1_SCLK,
	MX53_PAD_EIM_EB2__ECSPI1_SS0,
	MX53_PAD_EIM_D19__ECSPI1_SS1,
	MX53_PAD_EIM_D24__ECSPI1_SS2,
	MX53_PAD_EIM_D25__ECSPI1_SS3,
	MX53_PAD_GPIO_4__ESDHC2_CD,
	MX53_PAD_SD2_CLK__ESDHC2_CLK,
	MX53_PAD_SD2_CMD__ESDHC2_CMD,
	MX53_PAD_SD2_DATA0__ESDHC2_DAT0,
	MX53_PAD_SD2_DATA1__ESDHC2_DAT1,
	MX53_PAD_SD2_DATA2__ESDHC2_DAT2,
	MX53_PAD_SD2_DATA3__ESDHC2_DAT3,
	MX53_PAD_GPIO_2__ESDHC2_WP,
	MX53_PAD_PATA_IORDY__ESDHC3_CLK,
	MX53_PAD_PATA_RESET_B__ESDHC3_CMD,
	MX53_PAD_PATA_DATA8__ESDHC3_DAT0,
	MX53_PAD_PATA_DATA9__ESDHC3_DAT1,
	MX53_PAD_PATA_DATA10__ESDHC3_DAT2,
	MX53_PAD_PATA_DATA11__ESDHC3_DAT3,
	MX53_PAD_PATA_DATA0__ESDHC3_DAT4,
	MX53_PAD_PATA_DATA1__ESDHC3_DAT5,
	MX53_PAD_PATA_DATA2__ESDHC3_DAT6,
	MX53_PAD_PATA_DATA3__ESDHC3_DAT7,
	MX53_PAD_FEC_MDC__FEC_MDC,
	MX53_PAD_FEC_MDIO__FEC_MDIO,
	MX53_PAD_FEC_RXD0__FEC_RDATA_0,
	MX53_PAD_FEC_RXD1__FEC_RDATA_1,
	MX53_PAD_FEC_CRS_DV__FEC_RX_DV,
	MX53_PAD_FEC_RX_ER__FEC_RX_ER,
	MX53_PAD_FEC_TXD0__FEC_TDATA_0,
	MX53_PAD_FEC_TXD1__FEC_TDATA_1,
	MX53_PAD_FEC_REF_CLK__FEC_TX_CLK,
	MX53_PAD_FEC_TX_EN__FEC_TX_EN,
	MX53_PAD_GPIO_7__FIRI_RXD,
	MX53_PAD_GPIO_8__FIRI_TXD,
	MX53_PAD_GPIO_0__GPIO1_0,
	MX53_PAD_GPIO_3__GPIO1_3,
	MX53_PAD_PATA_DATA14__GPIO2_14,
	MX53_PAD_PATA_DATA15__GPIO2_15,
	MX53_PAD_EIM_CS0__GPIO2_23,
	MX53_PAD_EIM_OE__GPIO2_25,
	MX53_PAD_EIM_RW__GPIO2_26,
	MX53_PAD_EIM_LBA__GPIO2_27,
	MX53_PAD_PATA_DATA5__GPIO2_5,
	MX53_PAD_PATA_DATA6__GPIO2_6,
	MX53_PAD_PATA_DATA7__GPIO2_7,
	MX53_PAD_EIM_DA11__GPIO3_11,
	MX53_PAD_EIM_DA12__GPIO3_12,
	MX53_PAD_EIM_DA13__GPIO3_13,
	MX53_PAD_EIM_DA14__GPIO3_14,
	MX53_PAD_EIM_D20__GPIO3_20,
	MX53_PAD_EIM_D21__GPIO3_21,
	MX53_PAD_EIM_D22__GPIO3_22,
	MX53_PAD_EIM_D28__GPIO3_28,
	MX53_PAD_EIM_D29__GPIO3_29,
	MX53_PAD_EIM_WAIT__GPIO5_0,
	MX53_PAD_PATA_DA_1__GPIO7_7,
	MX53_PAD_PATA_DA_2__GPIO7_8,
	MX53_PAD_KEY_COL3__I2C2_SCL,
	MX53_PAD_KEY_ROW3__I2C2_SDA,
	MX53_PAD_GPIO_5__I2C3_SCL,
	MX53_PAD_GPIO_6__I2C3_SDA,
	MX53_PAD_CSI0_DAT10__IPU_CSI0_D_10,
	MX53_PAD_CSI0_DAT11__IPU_CSI0_D_11,
	MX53_PAD_CSI0_DAT12__IPU_CSI0_D_12,
	MX53_PAD_CSI0_DAT13__IPU_CSI0_D_13,
	MX53_PAD_CSI0_DAT14__IPU_CSI0_D_14,
	MX53_PAD_CSI0_DAT15__IPU_CSI0_D_15,
	MX53_PAD_CSI0_DAT16__IPU_CSI0_D_16,
	MX53_PAD_CSI0_DAT17__IPU_CSI0_D_17,
	MX53_PAD_CSI0_DAT18__IPU_CSI0_D_18,
	MX53_PAD_CSI0_DAT19__IPU_CSI0_D_19,
	MX53_PAD_CSI0_DAT4__IPU_CSI0_D_4,
	MX53_PAD_CSI0_DAT5__IPU_CSI0_D_5,
	MX53_PAD_CSI0_DAT6__IPU_CSI0_D_6,
	MX53_PAD_CSI0_DAT7__IPU_CSI0_D_7,
	MX53_PAD_CSI0_DAT8__IPU_CSI0_D_8,
	MX53_PAD_CSI0_DAT9__IPU_CSI0_D_9,
	MX53_PAD_CSI0_DATA_EN__IPU_CSI0_DATA_EN,
	MX53_PAD_CSI0_MCLK__IPU_CSI0_HSYNC,
	MX53_PAD_CSI0_PIXCLK__IPU_CSI0_PIXCLK,
	MX53_PAD_CSI0_VSYNC__IPU_CSI0_VSYNC,
	MX53_PAD_EIM_A16__IPU_DI1_DISP_CLK,
	MX53_PAD_EIM_DA10__IPU_DI1_PIN15,
	MX53_PAD_EIM_D23__IPU_DI1_PIN2,
	MX53_PAD_EIM_EB3__IPU_DI1_PIN3,
	MX53_PAD_EIM_DA15__IPU_DI1_PIN4,
	MX53_PAD_EIM_CS1__IPU_DI1_PIN6,
	MX53_PAD_EIM_DA9__IPU_DISP1_DAT_0,
	MX53_PAD_EIM_DA8__IPU_DISP1_DAT_1,
	MX53_PAD_EIM_EB1__IPU_DISP1_DAT_10,
	MX53_PAD_EIM_EB0__IPU_DISP1_DAT_11,
	MX53_PAD_EIM_A17__IPU_DISP1_DAT_12,
	MX53_PAD_EIM_A18__IPU_DISP1_DAT_13,
	MX53_PAD_EIM_A19__IPU_DISP1_DAT_14,
	MX53_PAD_EIM_A20__IPU_DISP1_DAT_15,
	MX53_PAD_EIM_A21__IPU_DISP1_DAT_16,
	MX53_PAD_EIM_A22__IPU_DISP1_DAT_17,
	MX53_PAD_EIM_A23__IPU_DISP1_DAT_18,
	MX53_PAD_EIM_A24__IPU_DISP1_DAT_19,
	MX53_PAD_EIM_DA7__IPU_DISP1_DAT_2,
	MX53_PAD_EIM_D31__IPU_DISP1_DAT_20,
	MX53_PAD_EIM_D30__IPU_DISP1_DAT_21,
	MX53_PAD_EIM_D26__IPU_DISP1_DAT_22,
	MX53_PAD_EIM_D27__IPU_DISP1_DAT_23,
	MX53_PAD_EIM_DA6__IPU_DISP1_DAT_3,
	MX53_PAD_EIM_DA5__IPU_DISP1_DAT_4,
	MX53_PAD_EIM_DA4__IPU_DISP1_DAT_5,
	MX53_PAD_EIM_DA3__IPU_DISP1_DAT_6,
	MX53_PAD_EIM_DA2__IPU_DISP1_DAT_7,
	MX53_PAD_EIM_DA1__IPU_DISP1_DAT_8,
	MX53_PAD_EIM_DA0__IPU_DISP1_DAT_9,
	MX53_PAD_LVDS0_CLK_P__LDB_LVDS0_CLK,
	MX53_PAD_LVDS0_TX0_P__LDB_LVDS0_TX0,
	MX53_PAD_LVDS0_TX1_P__LDB_LVDS0_TX1,
	MX53_PAD_LVDS0_TX2_P__LDB_LVDS0_TX2,
	MX53_PAD_LVDS0_TX3_P__LDB_LVDS0_TX3,
	MX53_PAD_LVDS1_CLK_P__LDB_LVDS1_CLK,
	MX53_PAD_LVDS1_TX0_P__LDB_LVDS1_TX0,
	MX53_PAD_LVDS1_TX1_P__LDB_LVDS1_TX1,
	MX53_PAD_LVDS1_TX2_P__LDB_LVDS1_TX2,
	MX53_PAD_LVDS1_TX3_P__LDB_LVDS1_TX3,
	MX53_PAD_GPIO_18__OWIRE_LINE,
	MX53_PAD_GPIO_1__PWM2_PWMO,
	MX53_PAD_GPIO_16__SPDIF_IN1,
	MX53_PAD_GPIO_17__SPDIF_OUT1,
	MX53_PAD_PATA_DMACK__UART1_RXD_MUX,
	MX53_PAD_PATA_DIOW__UART1_TXD_MUX,
	MX53_PAD_PATA_INTRQ__UART2_CTS,
	MX53_PAD_PATA_DIOR__UART2_RTS,
	MX53_PAD_PATA_BUFFER_EN__UART2_RXD_MUX,
	MX53_PAD_PATA_DMARQ__UART2_TXD_MUX,
	MX53_PAD_PATA_CS_1__UART3_RXD_MUX,
	MX53_PAD_PATA_CS_0__UART3_TXD_MUX,

	/* SD2 card detect */
	MX53_PAD_GPIO_4__GPIO1_4,
	/* SD2 write protect */
	MX53_PAD_GPIO_2__GPIO1_2,
	/* phy reset */
	MX53_PAD_PATA_DA_0__GPIO7_6,
};

#define GPIO_FEC_NRESET	IMX_GPIO_NR(7, 6)

#define GPIO_SD2_CD			IMX_GPIO_NR(1, 4)
#define GPIO_SD2_WP			IMX_GPIO_NR(1, 2)

static struct esdhc_platform_data tqma53_sd2_data = {
	.cd_gpio = GPIO_SD2_CD,
	.wp_gpio = GPIO_SD2_WP,
	.cd_type = ESDHC_CD_GPIO,
	.wp_type = ESDHC_WP_GPIO,
};

static struct esdhc_platform_data tqma53_sd3_data = {
	.cd_type = ESDHC_CD_PERMANENT,
	.wp_type = ESDHC_WP_NONE,
	.caps = MMC_CAP_4_BIT_DATA | MMC_CAP_8_BIT_DATA,
};

static int tqma53_devices_init(void)
{
	gpio_direction_output(GPIO_FEC_NRESET, 0);
	mdelay(1);
	gpio_set_value(GPIO_FEC_NRESET, 1);

	imx53_iim_register_fec_ethaddr();
	imx53_add_fec(&fec_info);
	imx53_add_mmc1(&tqma53_sd2_data);
	imx53_add_mmc2(&tqma53_sd3_data);

	armlinux_set_bootparams((void *)0x70000100);
	armlinux_set_architecture(MACH_TYPE_TQMA53);

	return 0;
}
device_initcall(tqma53_devices_init);

static int tqma53_part_init(void)
{
	devfs_add_partition("disk0", 0x00000, SZ_1M, DEVFS_PARTITION_FIXED, "self0");
	devfs_add_partition("disk0", SZ_1M, SZ_1M, DEVFS_PARTITION_FIXED, "env0");

	return 0;
}
late_initcall(tqma53_part_init);

static int tqma53_console_init(void)
{
	mxc_iomux_v3_setup_multiple_pads(tqma53_pads, ARRAY_SIZE(tqma53_pads));

	barebox_set_model("TQ tqma53");
	barebox_set_hostname("tqma53");

	imx53_add_uart1();

	return 0;
}
console_initcall(tqma53_console_init);
