/*
 * (C) Copyright 2010 Juergen Beisert - Pengutronix
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

/* 3322222222221111111111
 * 10987654321098765432109876543210
 *                              ^^^_ Register Number
 *                          ^^^^____ Bit offset
 *                        ^^________ Function
 *                       ^__________ Drive strength feature present
 *                      ^___________ Pull up present
 *                    ^^____________ Drive strength setting
 *                   ^______________ Pull up / bit keeper setting
 *                  ^_______________ Voltage select present
 *                 ^________________ Voltage selection
 *             ^____________________ direction if enabled as GPIO (1 = output)
 *            ^_____________________ initial output value if enabled as GPIO and configured as output
 *           ^______________________ Bit keeper present
 */
#ifndef __ASM_MACH_IOMUX_H
#define __ASM_MACH_IOMUX_H

/* control pad's function */
#define FBIT_SHIFT (3)
#define PORTF(bank,bit)	(((bit) << FBIT_SHIFT) | (bank))
#define GET_PORTF(x) ((x) & 0x7)
#define GET_FBITPOS(x) (((x) >> FBIT_SHIFT) & 0xf)
#define GET_GPIO_NO(x) ((GET_PORTF(x) << 4) + GET_FBITPOS(m))
#define FUNC_SHIFT 7
#define FUNC(x)	((x) << FUNC_SHIFT)
#define GET_FUNC(x) (((x) >> FUNC_SHIFT) & 3)
#define IS_GPIO (3)

/* control pad's GPIO feature if enabled */
#define GPIO_OUT (1 << 19)
#define GPIO_VALUE(x) ((x) << 20)
#define GPIO_IN (0 << 19)
#define GET_GPIODIR(x) (!!((x) & (1 << 19)))
#define GET_GPIOVAL(x) (!!((x) & (1 << 20)))

/* control pad's drive strength */
#define SE (1 << 9)
#define SE_PRESENT(x) (!!((x) & SE))
#define STRENGTH(x) ((x) << 11)
#define S4MA 0	/* used to define a 4 mA drive strength */
#define S8MA 1	/* used to define a 8 mA drive strength */
#define S12MA 2	/* used to define a 12 mA drive strength */
#define S16MA 3	/* used to define a 16 mA drive strength, not all pads can drive this current! */
#define GET_STRENGTH(x) (((x) >> 11) & 0x3)

/* control pad's pull up / bit keeper feature */
#define PE (1 << 10)
#define BK (1 << 21)
#define PE_PRESENT(x) (!!((x) & PE))
#define BK_PRESENT(x) (!!((x) & BK))
#define PULLUP(x) ((x) << 13)
#define BITKEEPER(x) ((x) << 14)
#define GET_PULLUP(x) (!!((x) & (1 << 13)))
#define GET_BITKEEPER(x) (!!((x) & BITKEEPER(1)))

/* control pad's voltage feature */
#define VE (1 << 14)
#define VE_PRESENT(x) (!!((x) & VE))
#define VE_1_8V (0 << 15)
#define VE_2_5V (0 << 15) /* don't ask my why, RTFM */
#define GET_VOLTAGE(x) (!!((x) & (1 << 15)))

/* Bank 0, pins 0 ... 15, GPIO pins 0 ... 15 */
#define GPMI_D15		(FUNC(0) | PORTF(0, 15) | SE | PE)
#define GPMI_D15_AUART2_TX	(FUNC(1) | PORTF(0, 15) | SE | PE)
#define GPMI_D15_GPMI_CE3N	(FUNC(2) | PORTF(0, 15) | SE | PE)
#define GPMI_D15_GPIO		(FUNC(3) | PORTF(0, 15) | SE | PE)
#define GPMI_D14		(FUNC(0) | PORTF(0, 14) | SE)
#define GPMI_D14_AUART2_RX	(FUNC(1) | PORTF(0, 14) | SE)
#define GPMI_D14_GPIO		(FUNC(3) | PORTF(0, 14) | SE)
#define GPMI_D13		(FUNC(0) | PORTF(0, 13) | SE)
#define GPMI_D13_LCD_D23	(FUNC(1) | PORTF(0, 13) | SE)
#define GPMI_D13_GPIO		(FUNC(3) | PORTF(0, 13) | SE)
#define GPMI_D12		(FUNC(0) | PORTF(0, 12) | SE)
#define GPMI_D12_LCD_D22	(FUNC(1) | PORTF(0, 12) | SE)
#define GPMI_D12_GPIO		(FUNC(3) | PORTF(0, 12) | SE)
#define GPMI_D11		(FUNC(0) | PORTF(0, 11) | SE | PE)
#define GPMI_D11_LCD_D21	(FUNC(1) | PORTF(0, 11) | SE | PE)
#define GPMI_D11_SSP1_D7	(FUNC(2) | PORTF(0, 11) | SE | PE)
#define GPMI_D11_GPIO		(FUNC(3) | PORTF(0, 11) | SE | PE)
#define GPMI_D10		(FUNC(0) | PORTF(0, 10) | SE | PE)
#define GPMI_D10_LCD_D20	(FUNC(1) | PORTF(0, 10) | SE | PE)
#define GPMI_D10_SSP1_D6	(FUNC(2) | PORTF(0, 10) | SE | PE)
#define GPMI_D10_GPIO		(FUNC(3) | PORTF(0, 10) | SE | PE)
#define GPMI_D09		(FUNC(0) | PORTF(0, 9) | SE | PE)
#define GPMI_D09_LCD_D19	(FUNC(1) | PORTF(0, 9) | SE | PE)
#define GPMI_D09_SSP1_D5	(FUNC(2) | PORTF(0, 9) | SE | PE)
#define GPMI_D09_GPIO		(FUNC(3) | PORTF(0, 9) | SE | PE)
#define GPMI_D08		(FUNC(0) | PORTF(0, 8) | SE | PE)
#define GPMI_D08_LCD_D18	(FUNC(1) | PORTF(0, 8) | SE | PE)
#define GPMI_D08_SSP1_D4	(FUNC(2) | PORTF(0, 8) | SE | PE)
#define GPMI_D08_GPIO		(FUNC(3) | PORTF(0, 8) | SE | PE)
#define GPMI_D07		(FUNC(0) | PORTF(0, 7) | SE | PE)
#define GPMI_D07_LCD_D15	(FUNC(1) | PORTF(0, 7) | SE | PE)
#define GPMI_D07_SSP2_D7	(FUNC(2) | PORTF(0, 7) | SE | PE)
#define GPMI_D07_GPIO		(FUNC(3) | PORTF(0, 7) | SE | PE)
#define GPMI_D06		(FUNC(0) | PORTF(0, 6) | SE | PE)
#define GPMI_D06_LCD_D14	(FUNC(1) | PORTF(0, 6) | SE | PE)
#define GPMI_D06_SSP2_D6	(FUNC(2) | PORTF(0, 6) | SE | PE)
#define GPMI_D06_GPIO		(FUNC(3) | PORTF(0, 6) | SE | PE)
#define GPMI_D05		(FUNC(0) | PORTF(0, 5) | SE | PE)
#define GPMI_D05_LCD_D13	(FUNC(1) | PORTF(0, 5) | SE | PE)
#define GPMI_D05_SSP2_D5	(FUNC(2) | PORTF(0, 5) | SE | PE)
#define GPMI_D05_GPIO		(FUNC(3) | PORTF(0, 5) | SE | PE)
#define GPMI_D04		(FUNC(0) | PORTF(0, 4) | SE | PE)
#define GPMI_D04_LCD_D12	(FUNC(1) | PORTF(0, 4) | SE | PE)
#define GPMI_D04_SSP2_D4	(FUNC(2) | PORTF(0, 4) | SE | PE)
#define GPMI_D04_GPIO		(FUNC(3) | PORTF(0, 4) | SE | PE)
#define GPMI_D03		(FUNC(0) | PORTF(0, 3) | SE | PE)
#define GPMI_D03_LCD_D11	(FUNC(1) | PORTF(0, 3) | SE | PE)
#define GPMI_D03_SSP2_D3	(FUNC(2) | PORTF(0, 3) | SE | PE)
#define GPMI_D03_GPIO		(FUNC(3) | PORTF(0, 3) | SE | PE)
#define GPMI_D02		(FUNC(0) | PORTF(0, 2) | SE | PE)
#define GPMI_D02_LCD_D10	(FUNC(1) | PORTF(0, 2) | SE | PE)
#define GPMI_D02_SSP2_D2	(FUNC(2) | PORTF(0, 2) | SE | PE)
#define GPMI_D02_GPIO		(FUNC(3) | PORTF(0, 2) | SE | PE)
#define GPMI_D01		(FUNC(0) | PORTF(0, 1) | SE | PE)
#define GPMI_D01_LCD_D9		(FUNC(1) | PORTF(0, 1) | SE | PE)
#define GPMI_D01_SSP2_D1	(FUNC(2) | PORTF(0, 1) | SE | PE)
#define GPMI_D01_GPIO		(FUNC(3) | PORTF(0, 1) | SE | PE)
#define GPMI_D00		(FUNC(0) | PORTF(0, 0) | SE | PE)
#define GPMI_D00_LCD_D8		(FUNC(1) | PORTF(0, 0) | SE | PE)
#define GPMI_D00_SSP2_D0	(FUNC(2) | PORTF(0, 0) | SE | PE)
#define GPMI_D00_GPIO		(FUNC(3) | PORTF(0, 0) | SE | PE)

/* Bank 0, pins 16 ... 31 GPIO pins 16 ... 31 */
#define I2C_SDA			(FUNC(0) | PORTF(1, 15) | SE)
#define I2C_SDA_GPMI_CE2N	(FUNC(1) | PORTF(1, 15) | SE)
#define I2C_SDA_AUART1_RX	(FUNC(2) | PORTF(1, 15) | SE)
#define I2C_SDA_GPIO		(FUNC(3) | PORTF(1, 15) | SE)
#define I2C_CLK			(FUNC(0) | PORTF(1, 14) | SE | PE)
#define I2C_CLK_GPMI_RDY2	(FUNC(1) | PORTF(1, 14) | SE | PE)
#define I2C_CLK_AUART1_TX	(FUNC(2) | PORTF(1, 14) | SE | PE)
#define I2C_CLK_GPIO		(FUNC(3) | PORTF(1, 14) | SE | PE)
#define AUART1_TX		(FUNC(0) | PORTF(1, 13) | SE | PE)
#define AUART1_TX_SSP1_D7	(FUNC(2) | PORTF(1, 13) | SE | PE)
#define AUART1_TX_GPIO		(FUNC(3) | PORTF(1, 13) | SE | PE)
#define AUART1_RX		(FUNC(0) | PORTF(1, 12) | SE | PE)
#define AUART1_RX_SSP1_D6	(FUNC(2) | PORTF(1, 12) | SE | PE)
#define AUART1_RX_GPIO		(FUNC(3) | PORTF(1, 12) | SE | PE)
#define AUART1_RTS		(FUNC(0) | PORTF(1, 11) | SE | PE)
#define AUART1_RTS_SSP1_D5	(FUNC(2) | PORTF(1, 11) | SE | PE)
#define AUART1_RTS_GPIO		(FUNC(3) | PORTF(1, 11) | SE | PE)
#define AUART1_CTS		(FUNC(0) | PORTF(1, 10) | SE | PE)
#define AUART1_CTS_SSP1_D4	(FUNC(2) | PORTF(1, 10) | SE | PE)
#define AUART1_CTS_GPIO		(FUNC(3) | PORTF(1, 10) | SE | PE)
#define GPMI_RDN		(FUNC(0) | PORTF(1, 9) | SE)
#define GPMI_RDN_GPIO		(FUNC(3) | PORTF(1, 9) | SE)
#define GPMI_WRN		(FUNC(0) | PORTF(1, 8) | SE)
#define GPMI_WRN_SSP2_SCK	(FUNC(2) | PORTF(1, 8) | SE)
#define GPMI_WRN_GPIO		(FUNC(3) | PORTF(1, 8) | SE)
#define GPMI_WPM		(FUNC(0) | PORTF(1, 7) | SE)
#define GPMI_WPM_GPIO		(FUNC(3) | PORTF(1, 7) | SE)
#define GPMI_RDY3		(FUNC(0) | PORTF(1, 6) | SE | PE)
#define GPMI_RDY3_GPIO		(FUNC(3) | PORTF(1, 6) | SE | PE)
#define GPMI_RDY2		(FUNC(0) | PORTF(1, 5) | SE | PE)
#define GPMI_RDY2_GPIO		(FUNC(3) | PORTF(1, 5) | SE | PE)
#define GPMI_RDY1		(FUNC(0) | PORTF(1, 4) | SE | PE)
#define GPMI_RDY1_SSP2_CMD	(FUNC(2) | PORTF(1, 4) | SE | PE)
#define GPMI_RDY1_GPIO		(FUNC(3) | PORTF(1, 4) | SE | PE)
#define GPMI_RDY0		(FUNC(0) | PORTF(1, 3) | SE | PE)
#define GPMI_RDY0_SSP2_DETECT	(FUNC(2) | PORTF(1, 3) | SE | PE)
#define GPMI_RDY0_GPIO		(FUNC(3) | PORTF(1, 3) | SE | PE)
#define GPMI_CE2N		(FUNC(0) | PORTF(1, 2) | SE | PE)
#define GPMI_CE2N_GPIO		(FUNC(3) | PORTF(1, 2) | SE | PE)
#define GPMI_ALE		(FUNC(0) | PORTF(1, 1) | SE)
#define GPMI_ALE_LCD_D17	(FUNC(1) | PORTF(1, 1) | SE)
#define GPMI_ALE_GPIO		(FUNC(3) | PORTF(1, 1) | SE)
#define GPMI_CLE		(FUNC(0) | PORTF(1, 0) | SE)
#define GPMI_CLE_LCD_D16	(FUNC(1) | PORTF(1, 1) | SE)
#define GPMI_CLE_GPIO		(FUNC(3) | PORTF(1, 0) | SE)

/* Bank 1, pins 0 ... 15 GPIO pins 32 ... 47 */
#define LCD_D15			(FUNC(0) | PORTF(2, 15) | SE)
#define LCD_D15_ETM_DA7		(FUNC(1) | PORTF(2, 15) | SE)
#define LCD_D15_SAIF1_SDATA1	(FUNC(2) | PORTF(2, 15) | SE)
#define LCD_D15_GPIO		(FUNC(3) | PORTF(2, 15) | SE)
#define LCD_D14			(FUNC(0) | PORTF(2, 14) | SE)
#define LCD_D14_ETM_DA6		(FUNC(1) | PORTF(2, 14) | SE)
#define LCD_D14_SAIF1_SDATA2	(FUNC(2) | PORTF(2, 14) | SE)
#define LCD_D14_GPIO		(FUNC(3) | PORTF(2, 14) | SE)
#define LCD_D13			(FUNC(0) | PORTF(2, 13) | SE)
#define LCD_D13_ETM_DA5		(FUNC(1) | PORTF(2, 13) | SE)
#define LCD_D13_SAIF2_SDATA2	(FUNC(2) | PORTF(2, 13) | SE)
#define LCD_D13_GPIO		(FUNC(3) | PORTF(2, 13) | SE)
#define LCD_D12			(FUNC(0) | PORTF(2, 12) | SE)
#define LCD_D12_ETM_DA4		(FUNC(1) | PORTF(2, 12) | SE)
#define LCD_D12_SAIF2_SDATA1	(FUNC(2) | PORTF(2, 12) | SE)
#define LCD_D12_GPIO		(FUNC(3) | PORTF(2, 12) | SE)
#define LCD_D11			(FUNC(0) | PORTF(2, 11) | SE)
#define LCD_D11_ETM_DA3		(FUNC(1) | PORTF(2, 11) | SE)
#define LCD_D11_SAIF_LRCLK	(FUNC(2) | PORTF(2, 11) | SE)
#define LCD_D11_GPIO		(FUNC(3) | PORTF(2, 11) | SE)
#define LCD_D10			(FUNC(0) | PORTF(2, 10) | SE)
#define LCD_D10_ETM_DA2		(FUNC(1) | PORTF(2, 10) | SE)
#define LCD_D10_SAIF_BITCLK	(FUNC(2) | PORTF(2, 10) | SE)
#define LCD_D10_GPIO		(FUNC(3) | PORTF(2, 10) | SE)
#define LCD_D9			(FUNC(0) | PORTF(2, 9) | SE)
#define LCD_D9_ETM_DA1		(FUNC(1) | PORTF(2, 9) | SE)
#define LCD_D9_SAIF1_SDATA0	(FUNC(2) | PORTF(2, 9) | SE)
#define LCD_D9_GPIO		(FUNC(3) | PORTF(2, 9) | SE)
#define LCD_D8			(FUNC(0) | PORTF(2, 8) | SE)
#define LCD_D8_ETM_DA0		(FUNC(1) | PORTF(2, 8) | SE)
#define LCD_D8_SAIF2_SDATA0	(FUNC(2) | PORTF(2, 8) | SE)
#define LCD_D8_GPIO		(FUNC(3) | PORTF(2, 8) | SE)
#define LCD_D7			(FUNC(0) | PORTF(2, 7) | SE)
#define LCD_D7_ETM_DA15		(FUNC(1) | PORTF(2, 7) | SE)
#define LCD_D7_GPIO		(FUNC(3) | PORTF(2, 7) | SE)
#define LCD_D6			(FUNC(0) | PORTF(2, 6) | SE)
#define LCD_D6_ETM_DA14		(FUNC(1) | PORTF(2, 6) | SE)
#define LCD_D6_GPIO		(FUNC(3) | PORTF(2, 6) | SE)
#define LCD_D5			(FUNC(0) | PORTF(2, 5) | SE)
#define LCD_D5_ETM_DA13		(FUNC(1) | PORTF(2, 5) | SE)
#define LCD_D5_GPIO		(FUNC(3) | PORTF(2, 5) | SE)
#define LCD_D4			(FUNC(0) | PORTF(2, 4) | SE)
#define LCD_D4_ETM_DA12		(FUNC(1) | PORTF(2, 4) | SE)
#define LCD_D4_GPIO		(FUNC(3) | PORTF(2, 4) | SE)
#define LCD_D3			(FUNC(0) | PORTF(2, 3) | SE)
#define LCD_D3_ETM_DA11		(FUNC(1) | PORTF(2, 3) | SE)
#define LCD_D3_GPIO		(FUNC(3) | PORTF(2, 3) | SE)
#define LCD_D2			(FUNC(0) | PORTF(2, 2) | SE)
#define LCD_D2_ETM_DA10		(FUNC(1) | PORTF(2, 2) | SE)
#define LCD_D2_GPIO		(FUNC(3) | PORTF(2, 2) | SE)
#define LCD_D1			(FUNC(0) | PORTF(2, 1) | SE)
#define LCD_D1_ETM_DA9		(FUNC(1) | PORTF(2, 1) | SE)
#define LCD_D1_GPIO		(FUNC(3) | PORTF(2, 1) | SE)
#define LCD_D0			(FUNC(0) | PORTF(2, 0) | SE)
#define LCD_D0_ETM_DA8		(FUNC(1) | PORTF(2, 0) | SE)
#define LCD_D0_GPIO		(FUNC(3) | PORTF(2, 0) | SE)

/* Bank 1, pins 16 ... 30 GPIO pins 48 ... 63 */
#define PWM4			(FUNC(0) | PORTF(3, 14) | SE)
#define PWM4_ETM_CLK		(FUNC(1) | PORTF(3, 14) | SE)
#define PWM4_AUART1_RTS		(FUNC(2) | PORTF(3, 14) | SE)
#define PWM4_GPIO		(FUNC(3) | PORTF(3, 14) | SE)
#define PWM3			(FUNC(0) | PORTF(3, 13) | SE)
#define PWM3_ETM_TCTL		(FUNC(1) | PORTF(3, 13) | SE)
#define PWM3_AUART1_CTS		(FUNC(2) | PORTF(3, 13) | SE)
#define PWM3_GPIO		(FUNC(3) | PORTF(3, 13) | SE)
#define PWM2			(FUNC(0) | PORTF(3, 12) | SE | PE)
#define PWM2_GPMI_READY3	(FUNC(1) | PORTF(3, 12) | SE | PE)
#define PWM2_GPIO		(FUNC(3) | PORTF(3, 12) | SE | PE)
#define PWM1			(FUNC(0) | PORTF(3, 11) | SE)
#define PWM1_TIMROT2		(FUNC(1) | PORTF(3, 11) | SE)
#define PWM1_DUART_TX		(FUNC(2) | PORTF(3, 11) | SE)
#define PWM1_GPIO		(FUNC(3) | PORTF(3, 11) | SE)
#define PWM0			(FUNC(0) | PORTF(3, 10) | SE)
#define PWM0_TIMROT1		(FUNC(1) | PORTF(3, 10) | SE)
#define PWM0_DUART_RX		(FUNC(2) | PORTF(3, 10) | SE)
#define PWM0_GPIO		(FUNC(3) | PORTF(3, 10) | SE)
#define LCD_VSYNC		(FUNC(0) | PORTF(3, 9) | SE)
#define LCD_VSYNC_LCD_BUSY	(FUNC(1) | PORTF(3, 9) | SE)
#define LCD_VSYNC_GPIO		(FUNC(3) | PORTF(3, 9) | SE)
#define LCD_HSYNC		(FUNC(0) | PORTF(3, 8) | SE)
#define LCD_HSYNC_I2C_SD	(FUNC(1) | PORTF(3, 8) | SE)
#define LCD_HSYNC_GPIO		(FUNC(3) | PORTF(3, 8) | SE)
#define LCD_ENABE		(FUNC(0) | PORTF(3, 7) | SE)
#define LCD_ENABE_I2C_CLK	(FUNC(1) | PORTF(3, 7) | SE)
#define LCD_ENABE_GPIO		(FUNC(3) | PORTF(3, 7) | SE)
#define LCD_DOTCLOCK		(FUNC(0) | PORTF(3, 6) | SE | PE)
#define LCD_DOTCLOCK_GPMI_READY3 (FUNC(1) | PORTF(3, 6) | SE | PE)
#define LCD_DOTCLOCK_GPIO	(FUNC(3) | PORTF(3, 6) | SE | PE)
#define LCD_CS			(FUNC(0) | PORTF(3, 5) | SE)
#define LCD_CS_GPIO		(FUNC(3) | PORTF(3, 5) | SE)
#define LCD_WR			(FUNC(0) | PORTF(3, 4) | SE)
#define LCD_WR_GPIO		(FUNC(3) | PORTF(3, 4) | SE)
#define LCD_RS			(FUNC(0) | PORTF(3, 3) | SE)
#define LCD_RS_ETM_TCLK		(FUNC(1) | PORTF(3, 3) | SE)
#define LCD_RS_GPIO		(FUNC(3) | PORTF(3, 3) | SE)
#define LCD_RESET		(FUNC(0) | PORTF(3, 2) | SE | PE)
#define LCD_RESET_ETM_TCTL	(FUNC(1) | PORTF(3, 2) | SE | PE)
#define LCD_RESET_GPMI_CE3N	(FUNC(2) | PORTF(3, 2) | SE | PE)
#define LCD_RESET_GPIO		(FUNC(3) | PORTF(3, 2) | SE | PE)
#define LCD_D17			(FUNC(0) | PORTF(3, 1) | SE)
#define LCD_D17_GPIO		(FUNC(3) | PORTF(3, 1) | SE)
#define LCD_D16			(FUNC(0) | PORTF(3, 0) | SE)
#define LCD_D16_SAIF_ALT_BITCLK	(FUNC(2) | PORTF(3, 0) | SE)
#define LCD_D16_GPIO		(FUNC(3) | PORTF(3, 0) | SE)

/* Bank 2, pins 0 ... 15 GPIO pins 64 ... 79 */
#define EMI_A6			(FUNC(0) | PORTF(4, 15) | SE | VE)
#define EMI_A6_GPIO		(FUNC(3) | PORTF(4, 15) | SE | VE)
#define EMI_A5			(FUNC(0) | PORTF(4, 14) | SE | VE)
#define EMI_A5_GPIO		(FUNC(3) | PORTF(4, 14) | SE | VE)
#define EMI_A4			(FUNC(0) | PORTF(4, 13) | SE | VE)
#define EMI_A4_GPIO		(FUNC(3) | PORTF(4, 13) | SE | VE)
#define EMI_A3			(FUNC(0) | PORTF(4, 12) | SE | VE)
#define EMI_A3_GPIO		(FUNC(3) | PORTF(4, 12) | SE | VE)
#define EMI_A2			(FUNC(0) | PORTF(4, 11) | SE | VE)
#define EMI_A2_GPIO		(FUNC(3) | PORTF(4, 11) | SE | VE)
#define EMI_A1			(FUNC(0) | PORTF(4, 10) | SE | VE)
#define EMI_A1_GPIO		(FUNC(3) | PORTF(4, 10) | SE | VE)
#define EMI_A0			(FUNC(0) | PORTF(4, 9) | SE | VE)
#define EMI_A0_GPIO		(FUNC(3) | PORTF(4, 9) | SE | VE)
#define ROTARYB			(FUNC(0) | PORTF(4, 8) | SE | PE)
#define ROTARYB_AUART2_CTS	(FUNC(1) | PORTF(4, 8) | SE | PE)
#define ROTARYB_GPMI_CE3N	(FUNC(2) | PORTF(4, 8) | SE | PE)
#define ROTARYB_GPIO		(FUNC(3) | PORTF(4, 8) | SE | PE)
#define ROTARYA			(FUNC(0) | PORTF(4, 7) | SE)
#define ROTARYA_AUART2_RTS	(FUNC(1) | PORTF(4, 7) | SE)
#define ROTARYA_SPDIF		(FUNC(2) | PORTF(4, 7) | SE)
#define ROTARYA_GPIO		(FUNC(3) | PORTF(4, 7) | SE)
#define SSP1_SCK		(FUNC(0) | PORTF(4, 6) | SE)
#define SSP1_SCK_ALT_JTAG_TRST	(FUNC(2) | PORTF(4, 6) | SE)
#define SSP1_SCK_GPIO		(FUNC(3) | PORTF(4, 6) | SE)
#define SSP1_DATA3		(FUNC(0) | PORTF(4, 5) | SE | PE)
#define SSP1_DATA3_ALT_JTAG_TMS	(FUNC(2) | PORTF(4, 5) | SE | PE)
#define SSP1_DATA3_GPIO		(FUNC(3) | PORTF(4, 5) | SE | PE)
#define SSP1_DATA2		(FUNC(0) | PORTF(4, 4) | SE | PE)
#define SSP1_DATA2_I2C_SD	(FUNC(1) | PORTF(4, 4) | SE | PE)
#define SSP1_DATA2_ALT_JTAG_RTCK (FUNC(2) | PORTF(4, 4) | SE | PE)
#define SSP1_DATA2_GPIO		(FUNC(3) | PORTF(4, 4) | SE | PE)
#define SSP1_DATA1		(FUNC(0) | PORTF(4, 3) | SE | PE)
#define SSP1_DATA1_I2C_CLK	(FUNC(1) | PORTF(4, 3) | SE | PE)
#define SSP1_DATA1_ALT_JTAG_TCK	(FUNC(2) | PORTF(4, 3) | SE | PE)
#define SSP1_DATA1_GPIO		(FUNC(3) | PORTF(4, 3) | SE | PE)
#define SSP1_DATA0		(FUNC(0) | PORTF(4, 2) | SE | PE)
#define SSP1_DATA0_ALT_JTAG_TDI	(FUNC(2) | PORTF(4, 2) | SE | PE)
#define SSP1_DATA0_GPIO		(FUNC(3) | PORTF(4, 2) | SE | PE)
#define SSP1_DETECT		(FUNC(0) | PORTF(4, 1) | SE | PE)
#define SSP1_DETECT_GPMI_CE3N	(FUNC(1) | PORTF(4, 1) | SE | PE)
#define SSP1_DETECT_USB_ID	(FUNC(2) | PORTF(4, 1) | SE | PE)
#define SSP1_DETECT_GPIO	(FUNC(3) | PORTF(4, 1) | SE | PE)
#define SSP1_CMD		(FUNC(0) | PORTF(4, 0) | SE | PE)
#define SSP1_CMD_JTAG_TDO	(FUNC(2) | PORTF(4, 0) | SE | PE)
#define SSP1_CMD_GPIO		(FUNC(3) | PORTF(4, 0) | SE | PE)

/* Bank 2, pins 16 ... 31 GPIO pins 80 ... 95 */
#define EMI_WEN			(FUNC(0) | PORTF(5, 15) | SE | VE)
#define EMI_WEN_GPIO		(FUNC(3) | PORTF(5, 15) | SE | VE)
#define EMI_RASN		(FUNC(0) | PORTF(5, 14) | SE | VE)
#define EMI_RASN_GPIO		(FUNC(3) | PORTF(5, 14) | SE | VE)
#define EMI_CKE			(FUNC(0) | PORTF(5, 13) | SE | VE)
#define EMI_CKE_GPIO		(FUNC(3) | PORTF(5, 13) | SE | VE)
#define GPMI_CE0N		(FUNC(0) | PORTF(5, 12) | SE)
#define GPMI_CE0N_GPIO		(FUNC(3) | PORTF(5, 12) | SE)
#define GPMI_CE1N		(FUNC(0) | PORTF(5, 11) | SE | PE)
#define GPMI_CE1N_GPIO		(FUNC(3) | PORTF(5, 11) | SE | PE)
#define EMI_CE1N		(FUNC(0) | PORTF(5, 10) | SE | VE | PE)
#define EMI_CE1N_GPIO		(FUNC(3) | PORTF(5, 10) | SE | VE | PE)
#define EMI_CE0N		(FUNC(0) | PORTF(5, 9) | SE | VE)
#define EMI_CE0N_GPIO		(FUNC(3) | PORTF(5, 9) | SE | VE)
#define EMI_CASN		(FUNC(0) | PORTF(5, 8) | SE | VE)
#define EMI_CASN_GPIO		(FUNC(3) | PORTF(5, 8) | SE | VE)
#define EMI_BA1			(FUNC(0) | PORTF(5, 7) | SE | VE)
#define EMI_BA1_GPIO		(FUNC(3) | PORTF(5, 7) | SE | VE)
#define EMI_BA0			(FUNC(0) | PORTF(5, 6) | SE | VE)
#define EMI_BA0_GPIO		(FUNC(3) | PORTF(5, 6) | SE | VE)
#define EMI_A12			(FUNC(0) | PORTF(5, 5) | SE | VE)
#define EMI_A12_GPIO		(FUNC(3) | PORTF(5, 5) | SE | VE)
#define EMI_A11			(FUNC(0) | PORTF(5, 4) | SE | VE)
#define EMI_A11_GPIO		(FUNC(3) | PORTF(5, 4) | SE | VE)
#define EMI_A10			(FUNC(0) | PORTF(5, 3) | SE | VE)
#define EMI_A10_GPIO		(FUNC(3) | PORTF(5, 3) | SE | VE)
#define EMI_A9			(FUNC(0) | PORTF(5, 2) | SE | VE)
#define EMI_A9_GPIO		(FUNC(3) | PORTF(5, 2) | SE | VE)
#define EMI_A8			(FUNC(0) | PORTF(5, 1) | SE | VE)
#define EMI_A8_GPIO		(FUNC(3) | PORTF(5, 1) | SE | VE)
#define EMI_A7			(FUNC(0) | PORTF(5, 0) | SE | VE)
#define EMI_A7_GPIO		(FUNC(3) | PORTF(5, 0) | SE | VE)

/* Bank 3, pins 0 ... 15 GPIO pins 96 ... 111 */
#define EMI_D15			(FUNC(0) | PORTF(6, 15) | SE | VE | PE)
#define EMI_D15_DISABLED	(FUNC(3) | PORTF(6, 15) | SE | VE | PE)
#define EMI_D14			(FUNC(0) | PORTF(6, 14) | SE | VE | PE)
#define EMI_D14_DISABLED	(FUNC(3) | PORTF(6, 14) | SE | VE | PE)
#define EMI_D13			(FUNC(0) | PORTF(6, 13) | SE | VE | PE)
#define EMI_D13_DISABLED	(FUNC(3) | PORTF(6, 13) | SE | VE | PE)
#define EMI_D12			(FUNC(0) | PORTF(6, 12) | SE | VE | PE)
#define EMI_D12_DISABLED	(FUNC(3) | PORTF(6, 12) | SE | VE | PE)
#define EMI_D11			(FUNC(0) | PORTF(6, 11) | SE | VE | PE)
#define EMI_D11_DISABLED	(FUNC(3) | PORTF(6, 11) | SE | VE | PE)
#define EMI_D10			(FUNC(0) | PORTF(6, 10) | SE | VE | PE)
#define EMI_D10_DISABLED	(FUNC(3) | PORTF(6, 10) | SE | VE | PE)
#define EMI_D9			(FUNC(0) | PORTF(6, 9) | SE | VE | PE)
#define EMI_D9_DISABLED		(FUNC(3) | PORTF(6, 9) | SE | VE | PE)
#define EMI_D8			(FUNC(0) | PORTF(6, 8) | SE | VE | PE)
#define EMI_D8_DISABLED		(FUNC(3) | PORTF(6, 8) | SE | VE | PE)
#define EMI_D7			(FUNC(0) | PORTF(6, 7) | SE | VE | PE)
#define EMI_D7_DISABLED		(FUNC(3) | PORTF(6, 7) | SE | VE | PE)
#define EMI_D6			(FUNC(0) | PORTF(6, 6) | SE | VE | PE)
#define EMI_D6_DISABLED		(FUNC(3) | PORTF(6, 6) | SE | VE | PE)
#define EMI_D5			(FUNC(0) | PORTF(6, 5) | SE | VE | PE)
#define EMI_D5_DISABLED		(FUNC(3) | PORTF(6, 5) | SE | VE | PE)
#define EMI_D4			(FUNC(0) | PORTF(6, 4) | SE | VE | PE)
#define EMI_D4_DISABLED		(FUNC(3) | PORTF(6, 4) | SE | VE | PE)
#define EMI_D3			(FUNC(0) | PORTF(6, 3) | SE | VE | PE)
#define EMI_D3_DISABLED		(FUNC(3) | PORTF(6, 3) | SE | VE | PE)
#define EMI_D2			(FUNC(0) | PORTF(6, 2) | SE | VE | PE)
#define EMI_D2_DISABLED		(FUNC(3) | PORTF(6, 2) | SE | VE | PE)
#define EMI_D1			(FUNC(0) | PORTF(6, 1) | SE | VE | PE)
#define EMI_D1_DISABLED		(FUNC(3) | PORTF(6, 1) | SE | VE | PE)
#define EMI_D0			(FUNC(0) | PORTF(6, 0) | SE | VE | PE)
#define EMI_D0_DISABLED		(FUNC(3) | PORTF(6, 0) | SE | VE | PE)

/* Bank 3, pins 16 ... 21 GPIO pins 112 ... 117 */
#define EMI_CLKN		(FUNC(0) | PORTF(7, 5) | SE | VE)
#define EMI_CLKN_DISABLED	(FUNC(3) | PORTF(7, 5) | SE | VE)
#define EMI_CLK			(FUNC(0) | PORTF(7, 4) | SE | VE)
#define EMI_CLK_DISABLED	(FUNC(3) | PORTF(7, 4) | SE | VE)
#define EMI_DQS1		(FUNC(0) | PORTF(7, 3) | SE | VE)
#define EMI_DQS1_DISABLED	(FUNC(3) | PORTF(7, 3) | SE | VE)
#define EMI_DQS0		(FUNC(0) | PORTF(7, 2) | SE | VE)
#define EMI_DQS0_DISABLED	(FUNC(3) | PORTF(7, 2) | SE | VE)
#define EMI_DQM1		(FUNC(0) | PORTF(7, 1) | SE | VE | PE)
#define EMI_DQM1_DISABLED	(FUNC(3) | PORTF(7, 1) | SE | VE | PE)
#define EMI_DQM0		(FUNC(0) | PORTF(7, 0) | SE | VE | PE)
#define EMI_DQM0_DISABLED	(FUNC(3) | PORTF(7, 0) | SE | VE | PE)

#endif /* __ASM_MACH_IOMUX_H */
