
#define DCD_ITEM(adr, val)	cpu_to_be32(adr), cpu_to_be32(val)
#define DCD_WR_CMD(len)		cpu_to_be32(0xcc << 24 | (len) << 8 | 0x04)
#define DCD_CHECK_CMD(a, b, c)	cpu_to_be32(a), cpu_to_be32(b), cpu_to_be32(c)

/*
 * This board uses advanced features of the DCD which do not corporate
 * well with our flash header defines. The DCD consists of commands which
 * have the length econded into them. Normally the DCDs only have a single
 * command (DCD_COMMAND_WRITE_TAG) which is already part of struct
 * imx_flash_header_v2. Now this board uses multiple commands, so we cannot
 * calculate the command length using sizeof(dcd_entry).
 */

DCD_NAME_XX30[] = {
	DCD_ITEM(0x53fd4068, 0xffcc0fff),
	DCD_ITEM(0x53fd406c, 0x000fffc3),
	DCD_ITEM(0x53fd4070, 0x033c0000),
	DCD_ITEM(0x53fd4074, 0x00000000),
	DCD_ITEM(0x53fd4078, 0x00000000),
	DCD_ITEM(0x53fd407c, 0x00fff033),
	DCD_ITEM(0x53fd4080, 0x0f00030f),
	DCD_ITEM(0x53fd4084, 0xfff00000),
	DCD_ITEM(0x53fd4088, 0x00000000),
	DCD_ITEM(0x53fa8174, 0x00000011),
	DCD_ITEM(0x53fa8318, 0x00000011),
	DCD_ITEM(0x63fd800c, 0x00000000),
	DCD_ITEM(0x53fd4014, 0x00888944),
	DCD_ITEM(0x53fd4018, 0x00016154),
	DCD_ITEM(0x53fa8724, 0x04000000),
	DCD_ITEM(0x53fa86f4, 0x00000000),
	DCD_ITEM(0x53fa8714, 0x00000000),
	DCD_ITEM(0x53fa86fc, 0x00000080),
	DCD_ITEM(0x53fa8710, 0x00000000),
	DCD_ITEM(0x53fa8708, 0x00000040),
	DCD_ITEM(0x53fa8584, 0x00280000),
	DCD_ITEM(0x53fa8594, 0x00280000),
	DCD_ITEM(0x53fa8560, 0x00280000),
	DCD_ITEM(0x53fa8554, 0x00280000),
	DCD_ITEM(0x53fa857c, 0x00a80040),
	DCD_ITEM(0x53fa8590, 0x00a80040),
	DCD_ITEM(0x53fa8568, 0x00a80040),
	DCD_ITEM(0x53fa8558, 0x00a80040),
	DCD_ITEM(0x53fa8580, 0x00280040),
	DCD_ITEM(0x53fa8578, 0x00280000),
	DCD_ITEM(0x53fa8564, 0x00280040),
	DCD_ITEM(0x53fa8570, 0x00280000),
	DCD_ITEM(0x53fa858c, 0x000000c0),
	DCD_ITEM(0x53fa855c, 0x000000c0),
	DCD_ITEM(0x53fa8574, 0x00280000),
	DCD_ITEM(0x53fa8588, 0x00280000),
	DCD_ITEM(0x53fa86f0, 0x00280000),
	DCD_ITEM(0x53fa8720, 0x00280000),
	DCD_ITEM(0x53fa8718, 0x00280000),
	DCD_ITEM(0x53fa871c, 0x00280000),
	DCD_ITEM(0x53fa8728, 0x00280000),
	DCD_ITEM(0x53fa872c, 0x00280000),
	DCD_ITEM(0x63fd904c, 0x001f001f),
	DCD_ITEM(0x63fd9050, 0x001f001f),
	DCD_ITEM(0x63fd907c, 0x011e011e),
	DCD_ITEM(0x63fd9080, 0x011f0120),
	DCD_ITEM(0x63fd9088, 0x3a393d3b),
	DCD_ITEM(0x63fd9090, 0x3f3f3f3f),
	DCD_ITEM(0x63fd9018, 0x00011740),
	DCD_ITEM(0x63fd9000, 0x83190000),
	DCD_ITEM(0x63fd900c, 0x3f435316),
	DCD_ITEM(0x63fd9010, 0xb66e0a63),
	DCD_ITEM(0x63fd9014, 0x01ff00db),
	DCD_ITEM(0x63fd902c, 0x000026d2),
	DCD_ITEM(0x63fd9030, 0x00430f24),
	DCD_ITEM(0x63fd9008, 0x1b221010),
	DCD_ITEM(0x63fd9004, 0x00030012),
	DCD_ITEM(0x63fd901c, 0x00008032),
	DCD_ITEM(0x63fd901c, 0x00008033),
	DCD_ITEM(0x63fd901c, 0x00408031),
	DCD_ITEM(0x63fd901c, 0x055080b0),
	DCD_ITEM(0x63fd9020, 0x00005800),
	DCD_ITEM(0x63fd9058, 0x00011112),
	DCD_ITEM(0x63fd90d0, 0x00000003),
	DCD_ITEM(0x63fd901c, 0x04008010),
	DCD_ITEM(0x63fd901c, 0x00008040),
	DCD_ITEM(0x63fd9040, 0x0539002b),
	DCD_CHECK_CMD(0xcf000c04, 0x63fd9040, 0x00010000),
	DCD_WR_CMD(0x24),
	DCD_ITEM(0x63fd901c, 0x00048033),
	DCD_ITEM(0x63fd901c, 0x00848231),
	DCD_ITEM(0x63fd901c, 0x00000000),
	DCD_ITEM(0x63fd9048, 0x00000001),
	DCD_CHECK_CMD(0xcf000c04, 0x63fd9048, 0x00000001),
	DCD_WR_CMD(0x2c),
	DCD_ITEM(0x63fd901c, 0x00048031),
	DCD_ITEM(0x63fd901c, 0x00008033),
	DCD_ITEM(0x63fd901c, 0x04008010),
	DCD_ITEM(0x63fd901c, 0x00048033),
	DCD_ITEM(0x63fd907c, 0x90000000),
	DCD_CHECK_CMD(0xcf000c04, 0x63fd907c, 0x90000000),
	DCD_WR_CMD(0x2c),
	DCD_ITEM(0x63fd901c, 0x00008033),
	DCD_ITEM(0x63fd901c, 0x00000000),
	DCD_ITEM(0x63fd901c, 0x04008010),
	DCD_ITEM(0x63fd901c, 0x00048033),
	DCD_ITEM(0x63fd90a4, 0x00000010),
	DCD_CHECK_CMD(0xcf000c04, 0x63fd90a4, 0x00000010),
	DCD_WR_CMD(0x24),
	DCD_ITEM(0x63fd901c, 0x00008033),
	DCD_ITEM(0x63fd901c, 0x04008010),
	DCD_ITEM(0x63fd901c, 0x00048033),
	DCD_ITEM(0x63fd90a0, 0x00000010),
	DCD_CHECK_CMD(0xcf000c04, 0x63fd90a0, 0x00000010),
	DCD_WR_CMD(0x010c),
	DCD_ITEM(0x63fd901c, 0x00008033),
	DCD_ITEM(0x63fd901c, 0x00000000),
	DCD_ITEM(0x53fa8004, 0x00194005),
	DCD_ITEM(0x53fa819c, 0x00000000),
	DCD_ITEM(0x53fa81a0, 0x00000000),
	DCD_ITEM(0x53fa81a4, 0x00000000),
	DCD_ITEM(0x53fa81a8, 0x00000000),
	DCD_ITEM(0x53fa81ac, 0x00000000),
	DCD_ITEM(0x53fa81b0, 0x00000000),
	DCD_ITEM(0x53fa81b4, 0x00000000),
	DCD_ITEM(0x53fa81b8, 0x00000000),
	DCD_ITEM(0x53fa81dc, 0x00000000),
	DCD_ITEM(0x53fa81e0, 0x00000000),
	DCD_ITEM(0x53fa8228, 0x00000000),
	DCD_ITEM(0x53fa822c, 0x00000000),
	DCD_ITEM(0x53fa8230, 0x00000000),
	DCD_ITEM(0x53fa8234, 0x00000000),
	DCD_ITEM(0x53fa8238, 0x00000000),
	DCD_ITEM(0x53fa84ec, 0x000000e4),
	DCD_ITEM(0x53fa84f0, 0x000000e4),
	DCD_ITEM(0x53fa84f4, 0x000000e4),
	DCD_ITEM(0x53fa84f8, 0x000000e4),
	DCD_ITEM(0x53fa84fc, 0x000000e4),
	DCD_ITEM(0x53fa8500, 0x000000e4),
	DCD_ITEM(0x53fa8504, 0x000000e4),
	DCD_ITEM(0x53fa8508, 0x000000e4),
	DCD_ITEM(0x53fa852c, 0x00000004),
	DCD_ITEM(0x53fa8530, 0x00000004),
	DCD_ITEM(0x53fa85a0, 0x00000004),
	DCD_ITEM(0x53fa85a4, 0x00000004),
	DCD_ITEM(0x53fa85a8, 0x000000e4),
	DCD_ITEM(0x53fa85ac, 0x000000e4),
	DCD_ITEM(0x53fa85b0, 0x00000004),
};
