/**
 * @file
 * @brief Generic Clock wrapper header.
 *
 * This includes each of the architecture Clock definitions under it.
 *
 * Originally from http://linux.omap.com/pub/bootloader/3430sdp/u-boot-v1.tar.gz
 *
 * (C) Copyright 2006-2008
 * Texas Instruments, <www.ti.com>
 * Richard Woodruff <r-woodruff2@ti.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __OMAP_CLOCKS_H_
#define __OMAP_CLOCKS_H_

#define LDELAY		12000000

/* Standard defines for Various clocks */
#define S12M		12000000
#define S13M		13000000
#define S19_2M		19200000
#define S24M		24000000
#define S26M		26000000
#define S38_4M		38400000

#ifdef CONFIG_ARCH_OMAP3
#include <mach/omap3-clock.h>
#endif
#ifdef CONFIG_ARCH_OMAP4
#include <mach/omap4-clock.h>
#endif

#endif /* __OMAP_CLOCKS_H_ */
