#ifndef __BOOT_H
#define __BOOT_H

#include <image.h>
#include <linux/list.h>

struct image_data {
	struct image_handle *os;
	struct image_handle *initrd;
	const char *oftree;
	int verify;
	unsigned long initrd_address;
	unsigned long initrd_size;
};

struct image_handler {
	struct list_head list;

	int image_type;
	int (*bootm)(struct image_data *data);
};

int register_image_handler(struct image_handler *handle);

#endif /* __BOOT_H */

