/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
#ifndef __ARCH_ARM_MACH_MX51_CRM_REGS_H__
#define __ARCH_ARM_MACH_MX51_CRM_REGS_H__

/* PLL Register Offsets */
#define MX51_PLL_DP_CTL			0x00
#define MX51_PLL_DP_CONFIG		0x04
#define MX51_PLL_DP_OP			0x08
#define MX51_PLL_DP_MFD			0x0C
#define MX51_PLL_DP_MFN			0x10
#define MX51_PLL_DP_MFNMINUS		0x14
#define MX51_PLL_DP_MFNPLUS		0x18
#define MX51_PLL_DP_HFS_OP		0x1C
#define MX51_PLL_DP_HFS_MFD		0x20
#define MX51_PLL_DP_HFS_MFN		0x24
#define MX51_PLL_DP_MFN_TOGC		0x28
#define MX51_PLL_DP_DESTAT		0x2c

/* PLL Register Bit definitions */
#define MX51_PLL_DP_CTL_MUL_CTRL		0x2000
#define MX51_PLL_DP_CTL_DPDCK0_2_EN	0x1000
#define MX51_PLL_DP_CTL_DPDCK0_2_OFFSET	12
#define MX51_PLL_DP_CTL_ADE		0x800
#define MX51_PLL_DP_CTL_REF_CLK_DIV	0x400
#define MX51_PLL_DP_CTL_REF_CLK_SEL_MASK	(3 << 8)
#define MX51_PLL_DP_CTL_REF_CLK_SEL_OFFSET	8
#define MX51_PLL_DP_CTL_HFSM		0x80
#define MX51_PLL_DP_CTL_PRE		0x40
#define MX51_PLL_DP_CTL_UPEN		0x20
#define MX51_PLL_DP_CTL_RST		0x10
#define MX51_PLL_DP_CTL_RCP		0x8
#define MX51_PLL_DP_CTL_PLM		0x4
#define MX51_PLL_DP_CTL_BRM0		0x2
#define MX51_PLL_DP_CTL_LRF		0x1

#define MX51_PLL_DP_CONFIG_BIST		0x8
#define MX51_PLL_DP_CONFIG_SJC_CE	0x4
#define MX51_PLL_DP_CONFIG_AREN		0x2
#define MX51_PLL_DP_CONFIG_LDREQ		0x1

#define MX51_PLL_DP_OP_MFI_OFFSET	4
#define MX51_PLL_DP_OP_MFI_MASK		(0xF << 4)
#define MX51_PLL_DP_OP_PDF_OFFSET	0
#define MX51_PLL_DP_OP_PDF_MASK		0xF

#define MX51_PLL_DP_MFD_OFFSET		0
#define MX51_PLL_DP_MFD_MASK		0x07FFFFFF

#define MX51_PLL_DP_MFN_OFFSET		0x0
#define MX51_PLL_DP_MFN_MASK		0x07FFFFFF

#define MX51_PLL_DP_MFN_TOGC_TOG_DIS	(1 << 17)
#define MX51_PLL_DP_MFN_TOGC_TOG_EN	(1 << 16)
#define MX51_PLL_DP_MFN_TOGC_CNT_OFFSET	0x0
#define MX51_PLL_DP_MFN_TOGC_CNT_MASK	0xFFFF

#define MX51_PLL_DP_DESTAT_TOG_SEL	(1 << 31)
#define MX51_PLL_DP_DESTAT_MFN		0x07FFFFFF

/* Assuming 24MHz input clock with doubler ON */
/*                            MFI         PDF */
#define MX51_PLL_DP_OP_850	((8 << 4) + ((1 - 1)  << 0))
#define MX51_PLL_DP_MFD_850	(48 - 1)
#define MX51_PLL_DP_MFN_850	41

#define MX51_PLL_DP_OP_800	((8 << 4) + ((1 - 1)  << 0))
#define MX51_PLL_DP_MFD_800	(3 - 1)
#define MX51_PLL_DP_MFN_800	1

#define MX51_PLL_DP_OP_700	((7 << 4) + ((1 - 1)  << 0))
#define MX51_PLL_DP_MFD_700	(24 - 1)
#define MX51_PLL_DP_MFN_700	7

#define MX51_PLL_DP_OP_665	((6 << 4) + ((1 - 1)  << 0))
#define MX51_PLL_DP_MFD_665	(96 - 1)
#define MX51_PLL_DP_MFN_665	89

#define MX51_PLL_DP_OP_532	((5 << 4) + ((1 - 1)  << 0))
#define MX51_PLL_DP_MFD_532	(24 - 1)
#define MX51_PLL_DP_MFN_532	13

#define MX51_PLL_DP_OP_400	((8 << 4) + ((2 - 1)  << 0))
#define MX51_PLL_DP_MFD_400	(3 - 1)
#define MX51_PLL_DP_MFN_400	1

#define MX51_PLL_DP_OP_216	((6 << 4) + ((3 - 1)  << 0))
#define MX51_PLL_DP_MFD_216	(4 - 1)
#define MX51_PLL_DP_MFN_216	3

/* Register addresses of CCM*/
#define MX51_CCM_CCR		0x00
#define MX51_CCM_CCDR		0x04
#define MX51_CCM_CSR		0x08
#define MX51_CCM_CCSR		0x0C
#define MX51_CCM_CACRR		0x10
#define MX51_CCM_CBCDR		0x14
#define MX51_CCM_CBCMR		0x18
#define MX51_CCM_CSCMR1		0x1C
#define MX51_CCM_CSCMR2		0x20
#define MX51_CCM_CSCDR1		0x24
#define MX51_CCM_CS1CDR		0x28
#define MX51_CCM_CS2CDR		0x2C
#define MX51_CCM_CDCDR		0x30
#define MX51_CCM_CHSCDR		0x34
#define MX51_CCM_CSCDR2		0x38
#define MX51_CCM_CSCDR3		0x3C
#define MX51_CCM_CSCDR4		0x40
#define MX51_CCM_CWDR		0x44
#define MX51_CCM_CDHIPR		0x48
#define MX51_CCM_CDCR		0x4C
#define MX51_CCM_CTOR		0x50
#define MX51_CCM_CLPCR		0x54
#define MX51_CCM_CISR		0x58
#define MX51_CCM_CIMR		0x5C
#define MX51_CCM_CCOSR		0x60
#define MX51_CCM_CGPR		0x64
#define MX51_CCM_CCGR0		0x68
#define MX51_CCM_CCGR1		0x6C
#define MX51_CCM_CCGR2		0x70
#define MX51_CCM_CCGR3		0x74
#define MX51_CCM_CCGR4		0x78
#define MX51_CCM_CCGR5		0x7C
#define MX51_CCM_CCGR6		0x80
#define MX51_CCM_CMEOR		0x84

/* Define the bits in register CCR */
#define MX51_CCM_CCR_COSC_EN		(1 << 12)
#define MX51_CCM_CCR_FPM_MULT_MASK	(1 << 11)
#define MX51_CCM_CCR_CAMP2_EN		(1 << 10)
#define MX51_CCM_CCR_CAMP1_EN		(1 << 9)
#define MX51_CCM_CCR_FPM_EN		(1 << 8)
#define MX51_CCM_CCR_OSCNT_OFFSET	(0)
#define MX51_CCM_CCR_OSCNT_MASK	(0xFF)

/* Define the bits in register CCDR */
#define MX51_CCM_CCDR_HSC_HS_MASK	(0x1 << 18)
#define MX51_CCM_CCDR_IPU_HS_MASK	(0x1 << 17)
#define MX51_CCM_CCDR_EMI_HS_MASK	(0x1 << 16)

/* Define the bits in register CSR */
#define MX51_CCM_CSR_COSR_READY	(1 << 5)
#define MX51_CCM_CSR_LVS_VALUE		(1 << 4)
#define MX51_CCM_CSR_CAMP2_READY	(1 << 3)
#define MX51_CCM_CSR_CAMP1_READY	(1 << 2)
#define MX51_CCM_CSR_FPM_READY	(1 << 1)
#define MX51_CCM_CSR_REF_EN_B		(1 << 0)

/* Define the bits in register CCSR */
#define MX51_CCM_CCSR_LP_APM_SEL		(0x1 << 9)
#define MX51_CCM_CCSR_STEP_SEL_OFFSET		(7)
#define MX51_CCM_CCSR_STEP_SEL_MASK		(0x3 << 7)
#define MX51_CCM_CCSR_PLL2_PODF_OFFSET	(5)
#define MX51_CCM_CCSR_PLL2_PODF_MASK		(0x3 << 5)
#define MX51_CCM_CCSR_PLL3_PODF_OFFSET	(3)
#define MX51_CCM_CCSR_PLL3_PODF_MASK		(0x3 << 3)
#define MX51_CCM_CCSR_PLL1_SW_CLK_SEL		(1 << 2)
#define MX51_CCM_CCSR_PLL2_SW_CLK_SEL		(1 << 1)
#define MX51_CCM_CCSR_PLL3_SW_CLK_SEL		(1 << 0)

/* Define the bits in register CACRR */
#define MX51_CCM_CACRR_ARM_PODF_OFFSET	(0)
#define MX51_CCM_CACRR_ARM_PODF_MASK		(0x7)

/* Define the bits in register CBCDR */
#define MX51_CCM_CBCDR_EMI_CLK_SEL			(0x1 << 26)
#define MX51_CCM_CBCDR_PERIPH_CLK_SEL			(0x1 << 25)
#define MX51_CCM_CBCDR_DDR_HF_SEL_OFFSET		(30)
#define MX51_CCM_CBCDR_DDR_HF_SEL			(0x1 << 30)
#define MX51_CCM_CBCDR_DDR_PODF_OFFSET		(27)
#define MX51_CCM_CBCDR_DDR_PODF_MASK			(0x7 << 27)
#define MX51_CCM_CBCDR_EMI_PODF_OFFSET		(22)
#define MX51_CCM_CBCDR_EMI_PODF_MASK			(0x7 << 22)
#define MX51_CCM_CBCDR_AXI_B_PODF_OFFSET		(19)
#define MX51_CCM_CBCDR_AXI_B_PODF_MASK		(0x7 << 19)
#define MX51_CCM_CBCDR_AXI_A_PODF_OFFSET		(16)
#define MX51_CCM_CBCDR_AXI_A_PODF_MASK		(0x7 << 16)
#define MX51_CCM_CBCDR_NFC_PODF_OFFSET		(13)
#define MX51_CCM_CBCDR_NFC_PODF_MASK			(0x7 << 13)
#define MX51_CCM_CBCDR_AHB_PODF_OFFSET		(10)
#define MX51_CCM_CBCDR_AHB_PODF_MASK			(0x7 << 10)
#define MX51_CCM_CBCDR_IPG_PODF_OFFSET		(8)
#define MX51_CCM_CBCDR_IPG_PODF_MASK			(0x3 << 8)
#define MX51_CCM_CBCDR_PERCLK_PRED1_OFFSET		(6)
#define MX51_CCM_CBCDR_PERCLK_PRED1_MASK		(0x3 << 6)
#define MX51_CCM_CBCDR_PERCLK_PRED2_OFFSET		(3)
#define MX51_CCM_CBCDR_PERCLK_PRED2_MASK		(0x7 << 3)
#define MX51_CCM_CBCDR_PERCLK_PODF_OFFSET		(0)
#define MX51_CCM_CBCDR_PERCLK_PODF_MASK		(0x7)

/* Define the bits in register CBCMR */
#define MX51_CCM_CBCMR_VPU_AXI_CLK_SEL_OFFSET	(14)
#define MX51_CCM_CBCMR_VPU_AXI_CLK_SEL_MASK		(0x3 << 14)
#define MX51_CCM_CBCMR_PERIPH_CLK_SEL_OFFSET		(12)
#define MX51_CCM_CBCMR_PERIPH_CLK_SEL_MASK		(0x3 << 12)
#define MX51_CCM_CBCMR_DDR_CLK_SEL_OFFSET		(10)
#define MX51_CCM_CBCMR_DDR_CLK_SEL_MASK		(0x3 << 10)
#define MX51_CCM_CBCMR_ARM_AXI_CLK_SEL_OFFSET	(8)
#define MX51_CCM_CBCMR_ARM_AXI_CLK_SEL_MASK		(0x3 << 8)
#define MX51_CCM_CBCMR_IPU_HSP_CLK_SEL_OFFSET	(6)
#define MX51_CCM_CBCMR_IPU_HSP_CLK_SEL_MASK		(0x3 << 6)
#define MX51_CCM_CBCMR_GPU_CLK_SEL_OFFSET		(4)
#define MX51_CCM_CBCMR_GPU_CLK_SEL_MASK		(0x3 << 4)
#define MX51_CCM_CBCMR_GPU2D_CLK_SEL_OFFSET        (14)
#define MX51_CCM_CBCMR_GPU2D_CLK_SEL_MASK      (0x3 << 14)
#define MX51_CCM_CBCMR_PERCLK_LP_APM_CLK_SEL		(0x1 << 1)
#define MX51_CCM_CBCMR_PERCLK_IPG_CLK_SEL		(0x1 << 0)

/* Define the bits in register CSCMR1 */
#define MX51_CCM_CSCMR1_SSI_EXT2_CLK_SEL_OFFSET		(30)
#define MX51_CCM_CSCMR1_SSI_EXT2_CLK_SEL_MASK		(0x3 << 30)
#define MX51_CCM_CSCMR1_SSI_EXT1_CLK_SEL_OFFSET		(28)
#define MX51_CCM_CSCMR1_SSI_EXT1_CLK_SEL_MASK		(0x3 << 28)
#define MX51_CCM_CSCMR1_USB_PHY_CLK_SEL_OFFSET		(26)
#define MX51_CCM_CSCMR1_USB_PHY_CLK_SEL			(0x1 << 26)
#define MX51_CCM_CSCMR1_UART_CLK_SEL_OFFSET			(24)
#define MX51_CCM_CSCMR1_UART_CLK_SEL_MASK			(0x3 << 24)
#define MX51_CCM_CSCMR1_USBOH3_CLK_SEL_OFFSET		(22)
#define MX51_CCM_CSCMR1_USBOH3_CLK_SEL_MASK			(0x3 << 22)
#define MX51_CCM_CSCMR1_ESDHC1_MSHC1_CLK_SEL_OFFSET	(20)
#define MX51_CCM_CSCMR1_ESDHC1_MSHC1_CLK_SEL_MASK		(0x3 << 20)
#define MX51_CCM_CSCMR1_ESDHC3_CLK_SEL			(0x1 << 19)
#define MX51_CCM_CSCMR1_ESDHC4_CLK_SEL			(0x1 << 18)
#define MX51_CCM_CSCMR1_ESDHC2_MSHC2_CLK_SEL_OFFSET	(16)
#define MX51_CCM_CSCMR1_ESDHC2_MSHC2_CLK_SEL_MASK		(0x3 << 16)
#define MX51_CCM_CSCMR1_SSI1_CLK_SEL_OFFSET			(14)
#define MX51_CCM_CSCMR1_SSI1_CLK_SEL_MASK			(0x3 << 14)
#define MX51_CCM_CSCMR1_SSI2_CLK_SEL_OFFSET			(12)
#define MX51_CCM_CSCMR1_SSI2_CLK_SEL_MASK			(0x3 << 12)
#define MX51_CCM_CSCMR1_SSI3_CLK_SEL				(0x1 << 11)
#define MX51_CCM_CSCMR1_VPU_RCLK_SEL				(0x1 << 10)
#define MX51_CCM_CSCMR1_SSI_APM_CLK_SEL_OFFSET		(8)
#define MX51_CCM_CSCMR1_SSI_APM_CLK_SEL_MASK		(0x3 << 8)
#define MX51_CCM_CSCMR1_TVE_CLK_SEL				(0x1 << 7)
#define MX51_CCM_CSCMR1_TVE_EXT_CLK_SEL			(0x1 << 6)
#define MX51_CCM_CSCMR1_CSPI_CLK_SEL_OFFSET			(4)
#define MX51_CCM_CSCMR1_CSPI_CLK_SEL_MASK			(0x3 << 4)
#define MX51_CCM_CSCMR1_SPDIF_CLK_SEL_OFFSET			(2)
#define MX51_CCM_CSCMR1_SPDIF_CLK_SEL_MASK			(0x3 << 2)
#define MX51_CCM_CSCMR1_SSI_EXT2_COM_CLK_SEL			(0x1 << 1)
#define MX51_CCM_CSCMR1_SSI_EXT1_COM_CLK_SEL			(0x1)

/* Define the bits in register CSCMR2 */
#define MX51_CCM_CSCMR2_DI_CLK_SEL_OFFSET(n)		(26+n*3)
#define MX51_CCM_CSCMR2_DI_CLK_SEL_MASK(n)		(0x7 << (26+n*3))
#define MX51_CCM_CSCMR2_CSI_MCLK2_CLK_SEL_OFFSET	(24)
#define MX51_CCM_CSCMR2_CSI_MCLK2_CLK_SEL_MASK	(0x3 << 24)
#define MX51_CCM_CSCMR2_CSI_MCLK1_CLK_SEL_OFFSET	(22)
#define MX51_CCM_CSCMR2_CSI_MCLK1_CLK_SEL_MASK	(0x3 << 22)
#define MX51_CCM_CSCMR2_ESC_CLK_SEL_OFFSET		(20)
#define MX51_CCM_CSCMR2_ESC_CLK_SEL_MASK		(0x3 << 20)
#define MX51_CCM_CSCMR2_HSC2_CLK_SEL_OFFSET		(18)
#define MX51_CCM_CSCMR2_HSC2_CLK_SEL_MASK		(0x3 << 18)
#define MX51_CCM_CSCMR2_HSC1_CLK_SEL_OFFSET		(16)
#define MX51_CCM_CSCMR2_HSC1_CLK_SEL_MASK		(0x3 << 16)
#define MX51_CCM_CSCMR2_HSI2C_CLK_SEL_OFFSET		(14)
#define MX51_CCM_CSCMR2_HSI2C_CLK_SEL_MASK		(0x3 << 14)
#define MX51_CCM_CSCMR2_FIRI_CLK_SEL_OFFSET		(12)
#define MX51_CCM_CSCMR2_FIRI_CLK_SEL_MASK		(0x3 << 12)
#define MX51_CCM_CSCMR2_SIM_CLK_SEL_OFFSET		(10)
#define MX51_CCM_CSCMR2_SIM_CLK_SEL_MASK		(0x3 << 10)
#define MX51_CCM_CSCMR2_SLIMBUS_COM			(0x1 << 9)
#define MX51_CCM_CSCMR2_SLIMBUS_CLK_SEL_OFFSET	(6)
#define MX51_CCM_CSCMR2_SLIMBUS_CLK_SEL_MASK		(0x7 << 6)
#define MX51_CCM_CSCMR2_SPDIF1_COM			(1 << 5)
#define MX51_CCM_CSCMR2_SPDIF0_COM			(1 << 4)
#define MX51_CCM_CSCMR2_SPDIF1_CLK_SEL_OFFSET	(2)
#define MX51_CCM_CSCMR2_SPDIF1_CLK_SEL_MASK		(0x3 << 2)
#define MX51_CCM_CSCMR2_SPDIF0_CLK_SEL_OFFSET	(0)
#define MX51_CCM_CSCMR2_SPDIF0_CLK_SEL_MASK		(0x3)

/* Define the bits in register CSCDR1 */
#define MX51_CCM_CSCDR1_ESDHC2_MSHC2_CLK_PRED_OFFSET	(22)
#define MX51_CCM_CSCDR1_ESDHC2_MSHC2_CLK_PRED_MASK		(0x7 << 22)
#define MX51_CCM_CSCDR1_ESDHC2_MSHC2_CLK_PODF_OFFSET	(19)
#define MX51_CCM_CSCDR1_ESDHC2_MSHC2_CLK_PODF_MASK		(0x7 << 19)
#define MX51_CCM_CSCDR1_ESDHC1_MSHC1_CLK_PRED_OFFSET	(16)
#define MX51_CCM_CSCDR1_ESDHC1_MSHC1_CLK_PRED_MASK		(0x7 << 16)
#define MX51_CCM_CSCDR1_PGC_CLK_PODF_OFFSET			(14)
#define MX51_CCM_CSCDR1_PGC_CLK_PODF_MASK			(0x3 << 14)
#define MX51_CCM_CSCDR1_ESDHC1_MSHC1_CLK_PODF_OFFSET	(11)
#define MX51_CCM_CSCDR1_ESDHC1_MSHC1_CLK_PODF_MASK		(0x7 << 11)
#define MX51_CCM_CSCDR1_USBOH3_CLK_PRED_OFFSET		(8)
#define MX51_CCM_CSCDR1_USBOH3_CLK_PRED_MASK		(0x7 << 8)
#define MX51_CCM_CSCDR1_USBOH3_CLK_PODF_OFFSET		(6)
#define MX51_CCM_CSCDR1_USBOH3_CLK_PODF_MASK		(0x3 << 6)
#define MX51_CCM_CSCDR1_UART_CLK_PRED_OFFSET		(3)
#define MX51_CCM_CSCDR1_UART_CLK_PRED_MASK			(0x7 << 3)
#define MX51_CCM_CSCDR1_UART_CLK_PODF_OFFSET		(0)
#define MX51_CCM_CSCDR1_UART_CLK_PODF_MASK			(0x7)

/* Define the bits in register CS1CDR and CS2CDR */
#define MX51_CCM_CS1CDR_SSI_EXT1_CLK_PRED_OFFSET	(22)
#define MX51_CCM_CS1CDR_SSI_EXT1_CLK_PRED_MASK	(0x7 << 22)
#define MX51_CCM_CS1CDR_SSI_EXT1_CLK_PODF_OFFSET	(16)
#define MX51_CCM_CS1CDR_SSI_EXT1_CLK_PODF_MASK	(0x3F << 16)
#define MX51_CCM_CS1CDR_SSI1_CLK_PRED_OFFSET		(6)
#define MX51_CCM_CS1CDR_SSI1_CLK_PRED_MASK		(0x7 << 6)
#define MX51_CCM_CS1CDR_SSI1_CLK_PODF_OFFSET		(0)
#define MX51_CCM_CS1CDR_SSI1_CLK_PODF_MASK		(0x3F)

#define MX51_CCM_CS2CDR_SSI_EXT2_CLK_PRED_OFFSET	(22)
#define MX51_CCM_CS2CDR_SSI_EXT2_CLK_PRED_MASK	(0x7 << 22)
#define MX51_CCM_CS2CDR_SSI_EXT2_CLK_PODF_OFFSET	(16)
#define MX51_CCM_CS2CDR_SSI_EXT2_CLK_PODF_MASK	(0x3F << 16)
#define MX51_CCM_CS2CDR_SSI2_CLK_PRED_OFFSET		(6)
#define MX51_CCM_CS2CDR_SSI2_CLK_PRED_MASK		(0x7 << 6)
#define MX51_CCM_CS2CDR_SSI2_CLK_PODF_OFFSET		(0)
#define MX51_CCM_CS2CDR_SSI2_CLK_PODF_MASK		(0x3F)

/* Define the bits in register CDCDR */
#define MX51_CCM_CDCDR_TVE_CLK_PRED_OFFSET		(28)
#define MX51_CCM_CDCDR_TVE_CLK_PRED_MASK		(0x7 << 28)
#define MX51_CCM_CDCDR_SPDIF0_CLK_PRED_OFFSET	(25)
#define MX51_CCM_CDCDR_SPDIF0_CLK_PRED_MASK		(0x7 << 25)
#define MX51_CCM_CDCDR_SPDIF0_CLK_PODF_OFFSET	(19)
#define MX51_CCM_CDCDR_SPDIF0_CLK_PODF_MASK		(0x3F << 19)
#define MX51_CCM_CDCDR_SPDIF1_CLK_PRED_OFFSET	(16)
#define MX51_CCM_CDCDR_SPDIF1_CLK_PRED_MASK		(0x7 << 16)
#define MX51_CCM_CDCDR_SPDIF1_CLK_PODF_OFFSET	(9)
#define MX51_CCM_CDCDR_SPDIF1_CLK_PODF_MASK		(0x3F << 9)
#define MX51_CCM_CDCDR_DI_CLK_PRED_OFFSET		(6)
#define MX51_CCM_CDCDR_DI_CLK_PRED_MASK		(0x7 << 6)
#define MX51_CCM_CDCDR_USB_PHY_PRED_OFFSET		(3)
#define MX51_CCM_CDCDR_USB_PHY_PRED_MASK		(0x7 << 3)
#define MX51_CCM_CDCDR_USB_PHY_PODF_OFFSET		(0)
#define MX51_CCM_CDCDR_USB_PHY_PODF_MASK		(0x7)

/* Define the bits in register CHSCCDR */
#define MX51_CCM_CHSCCDR_ESC_CLK_PRED_OFFSET		(12)
#define MX51_CCM_CHSCCDR_ESC_CLK_PRED_MASK		(0x7 << 12)
#define MX51_CCM_CHSCCDR_ESC_CLK_PODF_OFFSET	(6)
#define MX51_CCM_CHSCCDR_ESC_CLK_PODF_MASK		(0x3F << 6)
#define MX51_CCM_CHSCCDR_HSC2_CLK_PODF_OFFSET	(3)
#define MX51_CCM_CHSCCDR_HSC2_CLK_PODF_MASK		(0x7 << 3)
#define MX51_CCM_CHSCCDR_HSC1_CLK_PODF_OFFSET	(0)
#define MX51_CCM_CHSCCDR_HSC1_CLK_PODF_MASK		(0x7)

/* Define the bits in register CSCDR2 */
#define MX51_CCM_CSCDR2_CSPI_CLK_PRED_OFFSET		(25)
#define MX51_CCM_CSCDR2_CSPI_CLK_PRED_MASK		(0x7 << 25)
#define MX51_CCM_CSCDR2_CSPI_CLK_PODF_OFFSET		(19)
#define MX51_CCM_CSCDR2_CSPI_CLK_PODF_MASK		(0x3F << 19)
#define MX51_CCM_CSCDR2_SIM_CLK_PRED_OFFSET		(16)
#define MX51_CCM_CSCDR2_SIM_CLK_PRED_MASK		(0x7 << 16)
#define MX51_CCM_CSCDR2_SIM_CLK_PODF_OFFSET		(9)
#define MX51_CCM_CSCDR2_SIM_CLK_PODF_MASK		(0x3F << 9)
#define MX51_CCM_CSCDR2_SLIMBUS_CLK_PRED_OFFSET	(6)
#define MX51_CCM_CSCDR2_SLIMBUS_PRED_MASK		(0x7 << 6)
#define MX51_CCM_CSCDR2_SLIMBUS_PODF_OFFSET		(0)
#define MX51_CCM_CSCDR2_SLIMBUS_PODF_MASK		(0x3F)

/* Define the bits in register CSCDR3 */
#define MX51_CCM_CSCDR3_HSI2C_CLK_PRED_OFFSET	(16)
#define MX51_CCM_CSCDR3_HSI2C_CLK_PRED_MASK		(0x7 << 16)
#define MX51_CCM_CSCDR3_HSI2C_CLK_PODF_OFFSET	(9)
#define MX51_CCM_CSCDR3_HSI2C_CLK_PODF_MASK		(0x3F << 9)
#define MX51_CCM_CSCDR3_FIRI_CLK_PRED_OFFSET		(6)
#define MX51_CCM_CSCDR3_FIRI_CLK_PRED_MASK		(0x7 << 6)
#define MX51_CCM_CSCDR3_FIRI_CLK_PODF_OFFSET		(0)
#define MX51_CCM_CSCDR3_FIRI_CLK_PODF_MASK		(0x3F)

/* Define the bits in register CSCDR4 */
#define MX51_CCM_CSCDR4_CSI_MCLK2_CLK_PRED_OFFSET	(16)
#define MX51_CCM_CSCDR4_CSI_MCLK2_CLK_PRED_MASK	(0x7 << 16)
#define MX51_CCM_CSCDR4_CSI_MCLK2_CLK_PODF_OFFSET	(9)
#define MX51_CCM_CSCDR4_CSI_MCLK2_CLK_PODF_MASK	(0x3F << 9)
#define MX51_CCM_CSCDR4_CSI_MCLK1_CLK_PRED_OFFSET	(6)
#define MX51_CCM_CSCDR4_CSI_MCLK1_CLK_PRED_MASK	(0x7 << 6)
#define MX51_CCM_CSCDR4_CSI_MCLK1_CLK_PODF_OFFSET	(0)
#define MX51_CCM_CSCDR4_CSI_MCLK1_CLK_PODF_MASK	(0x3F)

/* Define the bits in register CDHIPR */
#define MX51_CCM_CDHIPR_ARM_PODF_BUSY			(1 << 16)
#define MX51_CCM_CDHIPR_DDR_HF_CLK_SEL_BUSY		(1 << 8)
#define MX51_CCM_CDHIPR_DDR_PODF_BUSY			(1 << 7)
#define MX51_CCM_CDHIPR_EMI_CLK_SEL_BUSY			(1 << 6)
#define MX51_CCM_CDHIPR_PERIPH_CLK_SEL_BUSY		(1 << 5)
#define MX51_CCM_CDHIPR_NFC_IPG_INT_MEM_PODF_BUSY	(1 << 4)
#define MX51_CCM_CDHIPR_AHB_PODF_BUSY			(1 << 3)
#define MX51_CCM_CDHIPR_EMI_PODF_BUSY			(1 << 2)
#define MX51_CCM_CDHIPR_AXI_B_PODF_BUSY			(1 << 1)
#define MX51_CCM_CDHIPR_AXI_A_PODF_BUSY			(1 << 0)

/* Define the bits in register CDCR */
#define MX51_CCM_CDCR_ARM_FREQ_SHIFT_DIVIDER			(0x1 << 2)
#define MX51_CCM_CDCR_PERIPH_CLK_DVFS_PODF_OFFSET		(0)
#define MX51_CCM_CDCR_PERIPH_CLK_DVFS_PODF_MASK		(0x3)

/* Define the bits in register CLPCR */
#define MX51_CCM_CLPCR_BYPASS_HSC_LPM_HS		(0x1 << 23)
#define MX51_CCM_CLPCR_BYPASS_SCC_LPM_HS		(0x1 << 22)
#define MX51_CCM_CLPCR_BYPASS_MAX_LPM_HS		(0x1 << 21)
#define MX51_CCM_CLPCR_BYPASS_SDMA_LPM_HS		(0x1 << 20)
#define MX51_CCM_CLPCR_BYPASS_EMI_LPM_HS		(0x1 << 19)
#define MX51_CCM_CLPCR_BYPASS_IPU_LPM_HS		(0x1 << 18)
#define MX51_CCM_CLPCR_BYPASS_RTIC_LPM_HS		(0x1 << 17)
#define MX51_CCM_CLPCR_BYPASS_RNGC_LPM_HS		(0x1 << 16)
#define MX51_CCM_CLPCR_COSC_PWRDOWN			(0x1 << 11)
#define MX51_CCM_CLPCR_STBY_COUNT_OFFSET		(9)
#define MX51_CCM_CLPCR_STBY_COUNT_MASK		(0x3 << 9)
#define MX51_CCM_CLPCR_VSTBY				(0x1 << 8)
#define MX51_CCM_CLPCR_DIS_REF_OSC			(0x1 << 7)
#define MX51_CCM_CLPCR_SBYOS				(0x1 << 6)
#define MX51_CCM_CLPCR_ARM_CLK_DIS_ON_LPM		(0x1 << 5)
#define MX51_CCM_CLPCR_LPSR_CLK_SEL_OFFSET		(3)
#define MX51_CCM_CLPCR_LPSR_CLK_SEL_MASK		(0x3 << 3)
#define MX51_CCM_CLPCR_LPM_OFFSET			(0)
#define MX51_CCM_CLPCR_LPM_MASK			(0x3)

/* Define the bits in register CISR */
#define MX51_CCM_CISR_ARM_PODF_LOADED			(0x1 << 25)
#define MX51_CCM_CISR_NFC_IPG_INT_MEM_PODF_LOADED		(0x1 << 21)
#define MX51_CCM_CISR_AHB_PODF_LOADED			(0x1 << 20)
#define MX51_CCM_CISR_EMI_PODF_LOADED				(0x1 << 19)
#define MX51_CCM_CISR_AXI_B_PODF_LOADED			(0x1 << 18)
#define MX51_CCM_CISR_AXI_A_PODF_LOADED			(0x1 << 17)
#define MX51_CCM_CISR_DIVIDER_LOADED				(0x1 << 16)
#define MX51_CCM_CISR_COSC_READY				(0x1 << 6)
#define MX51_CCM_CISR_CKIH2_READY				(0x1 << 5)
#define MX51_CCM_CISR_CKIH_READY				(0x1 << 4)
#define MX51_CCM_CISR_FPM_READY				(0x1 << 3)
#define MX51_CCM_CISR_LRF_PLL3					(0x1 << 2)
#define MX51_CCM_CISR_LRF_PLL2					(0x1 << 1)
#define MX51_CCM_CISR_LRF_PLL1					(0x1)

/* Define the bits in register CIMR */
#define MX51_CCM_CIMR_MASK_ARM_PODF_LOADED		(0x1 << 25)
#define MX51_CCM_CIMR_MASK_NFC_IPG_INT_MEM_PODF_LOADED	(0x1 << 21)
#define MX51_CCM_CIMR_MASK_EMI_PODF_LOADED		(0x1 << 20)
#define MX51_CCM_CIMR_MASK_AXI_C_PODF_LOADED		(0x1 << 19)
#define MX51_CCM_CIMR_MASK_AXI_B_PODF_LOADED		(0x1 << 18)
#define MX51_CCM_CIMR_MASK_AXI_A_PODF_LOADED		(0x1 << 17)
#define MX51_CCM_CIMR_MASK_DIVIDER_LOADED		(0x1 << 16)
#define MX51_CCM_CIMR_MASK_COSC_READY			(0x1 << 5)
#define MX51_CCM_CIMR_MASK_CKIH_READY			(0x1 << 4)
#define MX51_CCM_CIMR_MASK_FPM_READY			(0x1 << 3)
#define MX51_CCM_CIMR_MASK_LRF_PLL3			(0x1 << 2)
#define MX51_CCM_CIMR_MASK_LRF_PLL2			(0x1 << 1)
#define MX51_CCM_CIMR_MASK_LRF_PLL1			(0x1)

/* Define the bits in register CCOSR */
#define MX51_CCM_CCOSR_CKO2_EN_OFFSET			(0x1 << 24)
#define MX51_CCM_CCOSR_CKO2_DIV_OFFSET			(21)
#define MX51_CCM_CCOSR_CKO2_DIV_MASK			(0x7 << 21)
#define MX51_CCM_CCOSR_CKO2_SEL_OFFSET			(16)
#define MX51_CCM_CCOSR_CKO2_SEL_MASK			(0x1F << 16)
#define MX51_CCM_CCOSR_CKOL_EN				(0x1 << 7)
#define MX51_CCM_CCOSR_CKOL_DIV_OFFSET			(4)
#define MX51_CCM_CCOSR_CKOL_DIV_MASK			(0x7 << 4)
#define MX51_CCM_CCOSR_CKOL_SEL_OFFSET			(0)
#define MX51_CCM_CCOSR_CKOL_SEL_MASK			(0xF)

/* Define the bits in registers CGPR */
#define MX51_CCM_CGPR_EFUSE_PROG_SUPPLY_GATE		(0x1 << 4)
#define MX51_CCM_CGPR_FPM_SEL				(0x1 << 3)
#define MX51_CCM_CGPR_VL_L2BIST_CLKDIV_OFFSET		(0)
#define MX51_CCM_CGPR_VL_L2BIST_CLKDIV_MASK		(0x7)

/* Define the bits in registers CCGRx */
#define MX51_CCM_CCGR_CG_MASK				0x3
#define MX51_CCM_CCGR_MOD_OFF				0x0
#define MX51_CCM_CCGR_MOD_ON				0x3
#define MX51_CCM_CCGR_MOD_IDLE				0x1

#define MX51_CCM_CCGR0_CG15_OFFSET			30
#define MX51_CCM_CCGR0_CG15_MASK			(0x3 << 30)
#define MX51_CCM_CCGR0_CG14_OFFSET			28
#define MX51_CCM_CCGR0_CG14_MASK			(0x3 << 28)
#define MX51_CCM_CCGR0_CG13_OFFSET			26
#define MX51_CCM_CCGR0_CG13_MASK			(0x3 << 26)
#define MX51_CCM_CCGR0_CG12_OFFSET			24
#define MX51_CCM_CCGR0_CG12_MASK			(0x3 << 24)
#define MX51_CCM_CCGR0_CG11_OFFSET			22
#define MX51_CCM_CCGR0_CG11_MASK			(0x3 << 22)
#define MX51_CCM_CCGR0_CG10_OFFSET			20
#define MX51_CCM_CCGR0_CG10_MASK			(0x3 << 20)
#define MX51_CCM_CCGR0_CG9_OFFSET			18
#define MX51_CCM_CCGR0_CG9_MASK			(0x3 << 18)
#define MX51_CCM_CCGR0_CG8_OFFSET			16
#define MX51_CCM_CCGR0_CG8_MASK			(0x3 << 16)
#define MX51_CCM_CCGR0_CG7_OFFSET			14
#define MX51_CCM_CCGR0_CG6_OFFSET			12
#define MX51_CCM_CCGR0_CG5_OFFSET			10
#define MX51_CCM_CCGR0_CG5_MASK			(0x3 << 10)
#define MX51_CCM_CCGR0_CG4_OFFSET			8
#define MX51_CCM_CCGR0_CG4_MASK			(0x3 << 8)
#define MX51_CCM_CCGR0_CG3_OFFSET			6
#define MX51_CCM_CCGR0_CG3_MASK			(0x3 << 6)
#define MX51_CCM_CCGR0_CG2_OFFSET			4
#define MX51_CCM_CCGR0_CG2_MASK			(0x3 << 4)
#define MX51_CCM_CCGR0_CG1_OFFSET			2
#define MX51_CCM_CCGR0_CG1_MASK			(0x3 << 2)
#define MX51_CCM_CCGR0_CG0_OFFSET			0
#define MX51_CCM_CCGR0_CG0_MASK			0x3

#define MX51_CCM_CCGR1_CG15_OFFSET			30
#define MX51_CCM_CCGR1_CG14_OFFSET			28
#define MX51_CCM_CCGR1_CG13_OFFSET			26
#define MX51_CCM_CCGR1_CG12_OFFSET			24
#define MX51_CCM_CCGR1_CG11_OFFSET			22
#define MX51_CCM_CCGR1_CG10_OFFSET			20
#define MX51_CCM_CCGR1_CG9_OFFSET			18
#define MX51_CCM_CCGR1_CG8_OFFSET			16
#define MX51_CCM_CCGR1_CG7_OFFSET			14
#define MX51_CCM_CCGR1_CG6_OFFSET			12
#define MX51_CCM_CCGR1_CG5_OFFSET			10
#define MX51_CCM_CCGR1_CG4_OFFSET			8
#define MX51_CCM_CCGR1_CG3_OFFSET			6
#define MX51_CCM_CCGR1_CG2_OFFSET			4
#define MX51_CCM_CCGR1_CG1_OFFSET			2
#define MX51_CCM_CCGR1_CG0_OFFSET			0

#define MX51_CCM_CCGR2_CG15_OFFSET			30
#define MX51_CCM_CCGR2_CG14_OFFSET			28
#define MX51_CCM_CCGR2_CG13_OFFSET			26
#define MX51_CCM_CCGR2_CG12_OFFSET			24
#define MX51_CCM_CCGR2_CG11_OFFSET			22
#define MX51_CCM_CCGR2_CG10_OFFSET			20
#define MX51_CCM_CCGR2_CG9_OFFSET			18
#define MX51_CCM_CCGR2_CG8_OFFSET			16
#define MX51_CCM_CCGR2_CG7_OFFSET			14
#define MX51_CCM_CCGR2_CG6_OFFSET			12
#define MX51_CCM_CCGR2_CG5_OFFSET			10
#define MX51_CCM_CCGR2_CG4_OFFSET			8
#define MX51_CCM_CCGR2_CG3_OFFSET			6
#define MX51_CCM_CCGR2_CG2_OFFSET			4
#define MX51_CCM_CCGR2_CG1_OFFSET			2
#define MX51_CCM_CCGR2_CG0_OFFSET			0

#define MX51_CCM_CCGR3_CG15_OFFSET			30
#define MX51_CCM_CCGR3_CG14_OFFSET			28
#define MX51_CCM_CCGR3_CG13_OFFSET			26
#define MX51_CCM_CCGR3_CG12_OFFSET			24
#define MX51_CCM_CCGR3_CG11_OFFSET			22
#define MX51_CCM_CCGR3_CG10_OFFSET			20
#define MX51_CCM_CCGR3_CG9_OFFSET			18
#define MX51_CCM_CCGR3_CG8_OFFSET			16
#define MX51_CCM_CCGR3_CG7_OFFSET			14
#define MX51_CCM_CCGR3_CG6_OFFSET			12
#define MX51_CCM_CCGR3_CG5_OFFSET			10
#define MX51_CCM_CCGR3_CG4_OFFSET			8
#define MX51_CCM_CCGR3_CG3_OFFSET			6
#define MX51_CCM_CCGR3_CG2_OFFSET			4
#define MX51_CCM_CCGR3_CG1_OFFSET			2
#define MX51_CCM_CCGR3_CG0_OFFSET			0

#define MX51_CCM_CCGR4_CG15_OFFSET			30
#define MX51_CCM_CCGR4_CG14_OFFSET			28
#define MX51_CCM_CCGR4_CG13_OFFSET			26
#define MX51_CCM_CCGR4_CG12_OFFSET			24
#define MX51_CCM_CCGR4_CG11_OFFSET			22
#define MX51_CCM_CCGR4_CG10_OFFSET			20
#define MX51_CCM_CCGR4_CG9_OFFSET			18
#define MX51_CCM_CCGR4_CG8_OFFSET			16
#define MX51_CCM_CCGR4_CG7_OFFSET			14
#define MX51_CCM_CCGR4_CG6_OFFSET			12
#define MX51_CCM_CCGR4_CG5_OFFSET			10
#define MX51_CCM_CCGR4_CG4_OFFSET			8
#define MX51_CCM_CCGR4_CG3_OFFSET			6
#define MX51_CCM_CCGR4_CG2_OFFSET			4
#define MX51_CCM_CCGR4_CG1_OFFSET			2
#define MX51_CCM_CCGR4_CG0_OFFSET			0

#define MX51_CCM_CCGR5_CG15_OFFSET			30
#define MX51_CCM_CCGR5_CG14_OFFSET			28
#define MX51_CCM_CCGR5_CG14_MASK			(0x3 << 28)
#define MX51_CCM_CCGR5_CG13_OFFSET			26
#define MX51_CCM_CCGR5_CG13_MASK			(0x3 << 26)
#define MX51_CCM_CCGR5_CG12_OFFSET			24
#define MX51_CCM_CCGR5_CG12_MASK			(0x3 << 24)
#define MX51_CCM_CCGR5_CG11_OFFSET			22
#define MX51_CCM_CCGR5_CG11_MASK			(0x3 << 22)
#define MX51_CCM_CCGR5_CG10_OFFSET			20
#define MX51_CCM_CCGR5_CG10_MASK			(0x3 << 20)
#define MX51_CCM_CCGR5_CG9_OFFSET			18
#define MX51_CCM_CCGR5_CG9_MASK			(0x3 << 18)
#define MX51_CCM_CCGR5_CG8_OFFSET			16
#define MX51_CCM_CCGR5_CG8_MASK			(0x3 << 16)
#define MX51_CCM_CCGR5_CG7_OFFSET			14
#define MX51_CCM_CCGR5_CG7_MASK			(0x3 << 14)
#define MX51_CCM_CCGR5_CG6_OFFSET			12
#define MX51_CCM_CCGR5_CG5_OFFSET			10
#define MX51_CCM_CCGR5_CG4_OFFSET			8
#define MX51_CCM_CCGR5_CG3_OFFSET			6
#define MX51_CCM_CCGR5_CG2_OFFSET			4
#define MX51_CCM_CCGR5_CG2_MASK			(0x3 << 4)
#define MX51_CCM_CCGR5_CG1_OFFSET			2
#define MX51_CCM_CCGR5_CG0_OFFSET			0
#define MX51_CCM_CCGR6_CG7_OFFSET            14
#define MX51_CCM_CCGR6_CG7_MASK          (0x3 << 14)
#define MX51_CCM_CCGR6_CG6_OFFSET			12
#define MX51_CCM_CCGR6_CG6_MASK			(0x3 << 12)
#define MX51_CCM_CCGR6_CG5_OFFSET			10
#define MX51_CCM_CCGR6_CG5_MASK			(0x3 << 10)
#define MX51_CCM_CCGR6_CG4_OFFSET			8
#define MX51_CCM_CCGR6_CG4_MASK			(0x3 << 8)
#define MX51_CCM_CCGR6_CG3_OFFSET			6
#define MX51_CCM_CCGR6_CG2_OFFSET			4
#define MX51_CCM_CCGR6_CG1_OFFSET			2
#define MX51_CCM_CCGR6_CG0_OFFSET			0

/* CORTEXA8 platform */
#define MX51_CORTEXA8_PLAT_PVID		(MX51_CORTEXA8_BASE + 0x0)
#define MX51_CORTEXA8_PLAT_GPC		(MX51_CORTEXA8_BASE + 0x4)
#define MX51_CORTEXA8_PLAT_PIC		(MX51_CORTEXA8_BASE + 0x8)
#define MX51_CORTEXA8_PLAT_LPC		(MX51_CORTEXA8_BASE + 0xC)
#define MX51_CORTEXA8_PLAT_NEON_LPC	(MX51_CORTEXA8_BASE + 0x10)
#define MX51_CORTEXA8_PLAT_ICGC		(MX51_CORTEXA8_BASE + 0x14)
#define MX51_CORTEXA8_PLAT_AMC		(MX51_CORTEXA8_BASE + 0x18)
#define MX51_CORTEXA8_PLAT_NMC		(MX51_CORTEXA8_BASE + 0x20)
#define MX51_CORTEXA8_PLAT_NMS		(MX51_CORTEXA8_BASE + 0x24)

/* DVFS CORE */
#define MX51_DVFSTHRS		(MX51_DVFS_CORE_BASE + 0x00)
#define MX51_DVFSCOUN		(MX51_DVFS_CORE_BASE + 0x04)
#define MX51_DVFSSIG1		(MX51_DVFS_CORE_BASE + 0x08)
#define MX51_DVFSSIG0		(MX51_DVFS_CORE_BASE + 0x0C)
#define MX51_DVFSGPC0		(MX51_DVFS_CORE_BASE + 0x10)
#define MX51_DVFSGPC1		(MX51_DVFS_CORE_BASE + 0x14)
#define MX51_DVFSGPBT		(MX51_DVFS_CORE_BASE + 0x18)
#define MX51_DVFSEMAC		(MX51_DVFS_CORE_BASE + 0x1C)
#define MX51_DVFSCNTR		(MX51_DVFS_CORE_BASE + 0x20)
#define MX51_DVFSLTR0_0		(MX51_DVFS_CORE_BASE + 0x24)
#define MX51_DVFSLTR0_1		(MX51_DVFS_CORE_BASE + 0x28)
#define MX51_DVFSLTR1_0		(MX51_DVFS_CORE_BASE + 0x2C)
#define MX51_DVFSLTR1_1		(MX51_DVFS_CORE_BASE + 0x30)
#define MX51_DVFSPT0 		(MX51_DVFS_CORE_BASE + 0x34)
#define MX51_DVFSPT1 		(MX51_DVFS_CORE_BASE + 0x38)
#define MX51_DVFSPT2 		(MX51_DVFS_CORE_BASE + 0x3C)
#define MX51_DVFSPT3 		(MX51_DVFS_CORE_BASE + 0x40)

/* GPC */
#define MX51_GPC_CNTR		(MX51_GPC_BASE + 0x0)
#define MX51_GPC_PGR		(MX51_GPC_BASE + 0x4)
#define MX51_GPC_VCR		(MX51_GPC_BASE + 0x8)
#define MX51_GPC_ALL_PU		(MX51_GPC_BASE + 0xC)
#define MX51_GPC_NEON		(MX51_GPC_BASE + 0x10)
#define MX51_GPC_PGR_ARMPG_OFFSET	8
#define MX51_GPC_PGR_ARMPG_MASK		(3 << 8)

/* PGC */
#define MX51_PGC_IPU_PGCR	(MX51_PGC_IPU_BASE + 0x0)
#define MX51_PGC_IPU_PGSR	(MX51_PGC_IPU_BASE + 0xC)
#define MX51_PGC_VPU_PGCR	(MX51_PGC_VPU_BASE + 0x0)
#define MX51_PGC_VPU_PGSR	(MX51_PGC_VPU_BASE + 0xC)
#define MX51_PGC_GPU_PGCR	(MX51_PGC_GPU_BASE + 0x0)
#define MX51_PGC_GPU_PGSR	(MX51_PGC_GPU_BASE + 0xC)

#define MX51_PGCR_PCR		1
#define MX51_SRPGCR_PCR		1
#define MX51_EMPGCR_PCR		1
#define MX51_PGSR_PSR		1


#define MX51_CORTEXA8_PLAT_LPC_DSM	(1 << 0)
#define MX51_CORTEXA8_PLAT_LPC_DBG_DSM	(1 << 1)

/* SRPG */
#define MX51_SRPG_NEON_SRPGCR	(MX51_SRPG_NEON_BASE + 0x0)
#define MX51_SRPG_NEON_PUPSCR	(MX51_SRPG_NEON_BASE + 0x4)
#define MX51_SRPG_NEON_PDNSCR	(MX51_SRPG_NEON_BASE + 0x8)

#define MX51_SRPG_ARM_SRPGCR	(MX51_SRPG_ARM_BASE + 0x0)
#define MX51_SRPG_ARM_PUPSCR	(MX51_SRPG_ARM_BASE + 0x4)
#define MX51_SRPG_ARM_PDNSCR	(MX51_SRPG_ARM_BASE + 0x8)

#define MX51_SRPG_EMPGC0_SRPGCR	(MX51_SRPG_EMPGC0_BASE + 0x0)
#define MX51_SRPG_EMPGC0_PUPSCR	(MX51_SRPG_EMPGC0_BASE + 0x4)
#define MX51_SRPG_EMPGC0_PDNSCR	(MX51_SRPG_EMPGC0_BASE + 0x8)

#define MX51_SRPG_EMPGC1_SRPGCR	(MX51_SRPG_EMPGC1_BASE + 0x0)
#define MX51_SRPG_EMPGC1_PUPSCR	(MX51_SRPG_EMPGC1_BASE + 0x4)
#define MX51_SRPG_EMPGC1_PDNSCR	(MX51_SRPG_EMPGC1_BASE + 0x8)

#define MX51_SRPG_MEGAMIX_SRPGCR		(MX51_SRPG_MEGAMIX_BASE + 0x0)
#define MX51_SRPG_MEGAMIX_PUPSCR		(MX51_SRPG_MEGAMIX_BASE + 0x4)
#define MX51_SRPG_MEGAMIX_PDNSCR		(MX51_SRPG_MEGAMIX_BASE + 0x8)

#define MX51_SRPGC_EMI_SRPGCR	(MX51_SRPGC_EMI_BASE + 0x0)
#define MX51_SRPGC_EMI_PUPSCR	(MX51_SRPGC_EMI_BASE + 0x4)
#define MX51_SRPGC_EMI_PDNSCR	(MX51_SRPGC_EMI_BASE + 0x8)

#endif				/* __ARCH_ARM_MACH_MX51_CRM_REGS_H__ */


