/*
 * Copyright (c) 2008 Carsten Schlote <c.schlote@konzeptpark.de>
 * See file CREDITS for list of people who contributed to this project.
 *
 * This file is part of barebox.
 *
 * barebox is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * barebox is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with barebox.  If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Register and bit definitions for the MCF548X and MCF547x
 *  Interrupt Controller (INTC)
 */
#ifndef __MCF548X_INTC_H__
#define __MCF548X_INTC_H__

/*
 *  Interrupt Controller (INTC)
 */

/* Register read/write macros */
#define MCF_INTC_IPRH         (*(vuint32_t*)(&__MBAR[0x000700]))
#define MCF_INTC_IPRL         (*(vuint32_t*)(&__MBAR[0x000704]))
#define MCF_INTC_IMRH         (*(vuint32_t*)(&__MBAR[0x000708]))
#define MCF_INTC_IMRL         (*(vuint32_t*)(&__MBAR[0x00070C]))
#define MCF_INTC_INTFRCH      (*(vuint32_t*)(&__MBAR[0x000710]))
#define MCF_INTC_INTFRCL      (*(vuint32_t*)(&__MBAR[0x000714]))
#define MCF_INTC_IRLR         (*(vuint8_t *)(&__MBAR[0x000718]))
#define MCF_INTC_IACKLPR      (*(vuint8_t *)(&__MBAR[0x000719]))
#define MCF_INTC_ICR0         (*(vuint8_t *)(&__MBAR[0x000740]))
#define MCF_INTC_ICR1         (*(vuint8_t *)(&__MBAR[0x000741]))
#define MCF_INTC_ICR2         (*(vuint8_t *)(&__MBAR[0x000742]))
#define MCF_INTC_ICR3         (*(vuint8_t *)(&__MBAR[0x000743]))
#define MCF_INTC_ICR4         (*(vuint8_t *)(&__MBAR[0x000744]))
#define MCF_INTC_ICR5         (*(vuint8_t *)(&__MBAR[0x000745]))
#define MCF_INTC_ICR6         (*(vuint8_t *)(&__MBAR[0x000746]))
#define MCF_INTC_ICR7         (*(vuint8_t *)(&__MBAR[0x000747]))
#define MCF_INTC_ICR8         (*(vuint8_t *)(&__MBAR[0x000748]))
#define MCF_INTC_ICR9         (*(vuint8_t *)(&__MBAR[0x000749]))
#define MCF_INTC_ICR10        (*(vuint8_t *)(&__MBAR[0x00074A]))
#define MCF_INTC_ICR11        (*(vuint8_t *)(&__MBAR[0x00074B]))
#define MCF_INTC_ICR12        (*(vuint8_t *)(&__MBAR[0x00074C]))
#define MCF_INTC_ICR13        (*(vuint8_t *)(&__MBAR[0x00074D]))
#define MCF_INTC_ICR14        (*(vuint8_t *)(&__MBAR[0x00074E]))
#define MCF_INTC_ICR15        (*(vuint8_t *)(&__MBAR[0x00074F]))
#define MCF_INTC_ICR16        (*(vuint8_t *)(&__MBAR[0x000750]))
#define MCF_INTC_ICR17        (*(vuint8_t *)(&__MBAR[0x000751]))
#define MCF_INTC_ICR18        (*(vuint8_t *)(&__MBAR[0x000752]))
#define MCF_INTC_ICR19        (*(vuint8_t *)(&__MBAR[0x000753]))
#define MCF_INTC_ICR20        (*(vuint8_t *)(&__MBAR[0x000754]))
#define MCF_INTC_ICR21        (*(vuint8_t *)(&__MBAR[0x000755]))
#define MCF_INTC_ICR22        (*(vuint8_t *)(&__MBAR[0x000756]))
#define MCF_INTC_ICR23        (*(vuint8_t *)(&__MBAR[0x000757]))
#define MCF_INTC_ICR24        (*(vuint8_t *)(&__MBAR[0x000758]))
#define MCF_INTC_ICR25        (*(vuint8_t *)(&__MBAR[0x000759]))
#define MCF_INTC_ICR26        (*(vuint8_t *)(&__MBAR[0x00075A]))
#define MCF_INTC_ICR27        (*(vuint8_t *)(&__MBAR[0x00075B]))
#define MCF_INTC_ICR28        (*(vuint8_t *)(&__MBAR[0x00075C]))
#define MCF_INTC_ICR29        (*(vuint8_t *)(&__MBAR[0x00075D]))
#define MCF_INTC_ICR30        (*(vuint8_t *)(&__MBAR[0x00075E]))
#define MCF_INTC_ICR31        (*(vuint8_t *)(&__MBAR[0x00075F]))
#define MCF_INTC_ICR32        (*(vuint8_t *)(&__MBAR[0x000760]))
#define MCF_INTC_ICR33        (*(vuint8_t *)(&__MBAR[0x000761]))
#define MCF_INTC_ICR34        (*(vuint8_t *)(&__MBAR[0x000762]))
#define MCF_INTC_ICR35        (*(vuint8_t *)(&__MBAR[0x000763]))
#define MCF_INTC_ICR36        (*(vuint8_t *)(&__MBAR[0x000764]))
#define MCF_INTC_ICR37        (*(vuint8_t *)(&__MBAR[0x000765]))
#define MCF_INTC_ICR38        (*(vuint8_t *)(&__MBAR[0x000766]))
#define MCF_INTC_ICR39        (*(vuint8_t *)(&__MBAR[0x000767]))
#define MCF_INTC_ICR40        (*(vuint8_t *)(&__MBAR[0x000768]))
#define MCF_INTC_ICR41        (*(vuint8_t *)(&__MBAR[0x000769]))
#define MCF_INTC_ICR42        (*(vuint8_t *)(&__MBAR[0x00076A]))
#define MCF_INTC_ICR43        (*(vuint8_t *)(&__MBAR[0x00076B]))
#define MCF_INTC_ICR44        (*(vuint8_t *)(&__MBAR[0x00076C]))
#define MCF_INTC_ICR45        (*(vuint8_t *)(&__MBAR[0x00076D]))
#define MCF_INTC_ICR46        (*(vuint8_t *)(&__MBAR[0x00076E]))
#define MCF_INTC_ICR47        (*(vuint8_t *)(&__MBAR[0x00076F]))
#define MCF_INTC_ICR48        (*(vuint8_t *)(&__MBAR[0x000770]))
#define MCF_INTC_ICR49        (*(vuint8_t *)(&__MBAR[0x000771]))
#define MCF_INTC_ICR50        (*(vuint8_t *)(&__MBAR[0x000772]))
#define MCF_INTC_ICR51        (*(vuint8_t *)(&__MBAR[0x000773]))
#define MCF_INTC_ICR52        (*(vuint8_t *)(&__MBAR[0x000774]))
#define MCF_INTC_ICR53        (*(vuint8_t *)(&__MBAR[0x000775]))
#define MCF_INTC_ICR54        (*(vuint8_t *)(&__MBAR[0x000776]))
#define MCF_INTC_ICR55        (*(vuint8_t *)(&__MBAR[0x000777]))
#define MCF_INTC_ICR56        (*(vuint8_t *)(&__MBAR[0x000778]))
#define MCF_INTC_ICR57        (*(vuint8_t *)(&__MBAR[0x000779]))
#define MCF_INTC_ICR58        (*(vuint8_t *)(&__MBAR[0x00077A]))
#define MCF_INTC_ICR59        (*(vuint8_t *)(&__MBAR[0x00077B]))
#define MCF_INTC_ICR60        (*(vuint8_t *)(&__MBAR[0x00077C]))
#define MCF_INTC_ICR61        (*(vuint8_t *)(&__MBAR[0x00077D]))
#define MCF_INTC_ICR62        (*(vuint8_t *)(&__MBAR[0x00077E]))
#define MCF_INTC_ICR63        (*(vuint8_t *)(&__MBAR[0x00077F]))
#define MCF_INTC_ICRn(x)      (*(vuint8_t *)(&__MBAR[0x000740+((x)*0x001)]))
#define MCF_INTC_SWIACK       (*(vuint8_t *)(&__MBAR[0x0007E0]))
#define MCF_INTC_L1IACK       (*(vuint8_t *)(&__MBAR[0x0007E4]))
#define MCF_INTC_L2IACK       (*(vuint8_t *)(&__MBAR[0x0007E8]))
#define MCF_INTC_L3IACK       (*(vuint8_t *)(&__MBAR[0x0007EC]))
#define MCF_INTC_L4IACK       (*(vuint8_t *)(&__MBAR[0x0007F0]))
#define MCF_INTC_L5IACK       (*(vuint8_t *)(&__MBAR[0x0007F4]))
#define MCF_INTC_L6IACK       (*(vuint8_t *)(&__MBAR[0x0007F8]))
#define MCF_INTC_L7IACK       (*(vuint8_t *)(&__MBAR[0x0007FC]))
#define MCF_INTC_LnIACK(x)    (*(vuint8_t *)(&__MBAR[0x0007E4+((x)*0x004)]))

/* Bit definitions and macros for MCF_INTC_IPRH */
#define MCF_INTC_IPRH_INT32          (0x00000001)
#define MCF_INTC_IPRH_INT33          (0x00000002)
#define MCF_INTC_IPRH_INT34          (0x00000004)
#define MCF_INTC_IPRH_INT35          (0x00000008)
#define MCF_INTC_IPRH_INT36          (0x00000010)
#define MCF_INTC_IPRH_INT37          (0x00000020)
#define MCF_INTC_IPRH_INT38          (0x00000040)
#define MCF_INTC_IPRH_INT39          (0x00000080)
#define MCF_INTC_IPRH_INT40          (0x00000100)
#define MCF_INTC_IPRH_INT41          (0x00000200)
#define MCF_INTC_IPRH_INT42          (0x00000400)
#define MCF_INTC_IPRH_INT43          (0x00000800)
#define MCF_INTC_IPRH_INT44          (0x00001000)
#define MCF_INTC_IPRH_INT45          (0x00002000)
#define MCF_INTC_IPRH_INT46          (0x00004000)
#define MCF_INTC_IPRH_INT47          (0x00008000)
#define MCF_INTC_IPRH_INT48          (0x00010000)
#define MCF_INTC_IPRH_INT49          (0x00020000)
#define MCF_INTC_IPRH_INT50          (0x00040000)
#define MCF_INTC_IPRH_INT51          (0x00080000)
#define MCF_INTC_IPRH_INT52          (0x00100000)
#define MCF_INTC_IPRH_INT53          (0x00200000)
#define MCF_INTC_IPRH_INT54          (0x00400000)
#define MCF_INTC_IPRH_INT55          (0x00800000)
#define MCF_INTC_IPRH_INT56          (0x01000000)
#define MCF_INTC_IPRH_INT57          (0x02000000)
#define MCF_INTC_IPRH_INT58          (0x04000000)
#define MCF_INTC_IPRH_INT59          (0x08000000)
#define MCF_INTC_IPRH_INT60          (0x10000000)
#define MCF_INTC_IPRH_INT61          (0x20000000)
#define MCF_INTC_IPRH_INT62          (0x40000000)
#define MCF_INTC_IPRH_INT63          (0x80000000)

/* Bit definitions and macros for MCF_INTC_IPRL */
#define MCF_INTC_IPRL_INT1           (0x00000002)
#define MCF_INTC_IPRL_INT2           (0x00000004)
#define MCF_INTC_IPRL_INT3           (0x00000008)
#define MCF_INTC_IPRL_INT4           (0x00000010)
#define MCF_INTC_IPRL_INT5           (0x00000020)
#define MCF_INTC_IPRL_INT6           (0x00000040)
#define MCF_INTC_IPRL_INT7           (0x00000080)
#define MCF_INTC_IPRL_INT8           (0x00000100)
#define MCF_INTC_IPRL_INT9           (0x00000200)
#define MCF_INTC_IPRL_INT10          (0x00000400)
#define MCF_INTC_IPRL_INT11          (0x00000800)
#define MCF_INTC_IPRL_INT12          (0x00001000)
#define MCF_INTC_IPRL_INT13          (0x00002000)
#define MCF_INTC_IPRL_INT14          (0x00004000)
#define MCF_INTC_IPRL_INT15          (0x00008000)
#define MCF_INTC_IPRL_INT16          (0x00010000)
#define MCF_INTC_IPRL_INT17          (0x00020000)
#define MCF_INTC_IPRL_INT18          (0x00040000)
#define MCF_INTC_IPRL_INT19          (0x00080000)
#define MCF_INTC_IPRL_INT20          (0x00100000)
#define MCF_INTC_IPRL_INT21          (0x00200000)
#define MCF_INTC_IPRL_INT22          (0x00400000)
#define MCF_INTC_IPRL_INT23          (0x00800000)
#define MCF_INTC_IPRL_INT24          (0x01000000)
#define MCF_INTC_IPRL_INT25          (0x02000000)
#define MCF_INTC_IPRL_INT26          (0x04000000)
#define MCF_INTC_IPRL_INT27          (0x08000000)
#define MCF_INTC_IPRL_INT28          (0x10000000)
#define MCF_INTC_IPRL_INT29          (0x20000000)
#define MCF_INTC_IPRL_INT30          (0x40000000)
#define MCF_INTC_IPRL_INT31          (0x80000000)

/* Bit definitions and macros for MCF_INTC_IMRH */
#define MCF_INTC_IMRH_INT_MASK32     (0x00000001)
#define MCF_INTC_IMRH_INT_MASK33     (0x00000002)
#define MCF_INTC_IMRH_INT_MASK34     (0x00000004)
#define MCF_INTC_IMRH_INT_MASK35     (0x00000008)
#define MCF_INTC_IMRH_INT_MASK36     (0x00000010)
#define MCF_INTC_IMRH_INT_MASK37     (0x00000020)
#define MCF_INTC_IMRH_INT_MASK38     (0x00000040)
#define MCF_INTC_IMRH_INT_MASK39     (0x00000080)
#define MCF_INTC_IMRH_INT_MASK40     (0x00000100)
#define MCF_INTC_IMRH_INT_MASK41     (0x00000200)
#define MCF_INTC_IMRH_INT_MASK42     (0x00000400)
#define MCF_INTC_IMRH_INT_MASK43     (0x00000800)
#define MCF_INTC_IMRH_INT_MASK44     (0x00001000)
#define MCF_INTC_IMRH_INT_MASK45     (0x00002000)
#define MCF_INTC_IMRH_INT_MASK46     (0x00004000)
#define MCF_INTC_IMRH_INT_MASK47     (0x00008000)
#define MCF_INTC_IMRH_INT_MASK48     (0x00010000)
#define MCF_INTC_IMRH_INT_MASK49     (0x00020000)
#define MCF_INTC_IMRH_INT_MASK50     (0x00040000)
#define MCF_INTC_IMRH_INT_MASK51     (0x00080000)
#define MCF_INTC_IMRH_INT_MASK52     (0x00100000)
#define MCF_INTC_IMRH_INT_MASK53     (0x00200000)
#define MCF_INTC_IMRH_INT_MASK54     (0x00400000)
#define MCF_INTC_IMRH_INT_MASK55     (0x00800000)
#define MCF_INTC_IMRH_INT_MASK56     (0x01000000)
#define MCF_INTC_IMRH_INT_MASK57     (0x02000000)
#define MCF_INTC_IMRH_INT_MASK58     (0x04000000)
#define MCF_INTC_IMRH_INT_MASK59     (0x08000000)
#define MCF_INTC_IMRH_INT_MASK60     (0x10000000)
#define MCF_INTC_IMRH_INT_MASK61     (0x20000000)
#define MCF_INTC_IMRH_INT_MASK62     (0x40000000)
#define MCF_INTC_IMRH_INT_MASK63     (0x80000000)

/* Bit definitions and macros for MCF_INTC_IMRL */
#define MCF_INTC_IMRL_MASKALL        (0x00000001)
#define MCF_INTC_IMRL_INT_MASK1      (0x00000002)
#define MCF_INTC_IMRL_INT_MASK2      (0x00000004)
#define MCF_INTC_IMRL_INT_MASK3      (0x00000008)
#define MCF_INTC_IMRL_INT_MASK4      (0x00000010)
#define MCF_INTC_IMRL_INT_MASK5      (0x00000020)
#define MCF_INTC_IMRL_INT_MASK6      (0x00000040)
#define MCF_INTC_IMRL_INT_MASK7      (0x00000080)
#define MCF_INTC_IMRL_INT_MASK8      (0x00000100)
#define MCF_INTC_IMRL_INT_MASK9      (0x00000200)
#define MCF_INTC_IMRL_INT_MASK10     (0x00000400)
#define MCF_INTC_IMRL_INT_MASK11     (0x00000800)
#define MCF_INTC_IMRL_INT_MASK12     (0x00001000)
#define MCF_INTC_IMRL_INT_MASK13     (0x00002000)
#define MCF_INTC_IMRL_INT_MASK14     (0x00004000)
#define MCF_INTC_IMRL_INT_MASK15     (0x00008000)
#define MCF_INTC_IMRL_INT_MASK16     (0x00010000)
#define MCF_INTC_IMRL_INT_MASK17     (0x00020000)
#define MCF_INTC_IMRL_INT_MASK18     (0x00040000)
#define MCF_INTC_IMRL_INT_MASK19     (0x00080000)
#define MCF_INTC_IMRL_INT_MASK20     (0x00100000)
#define MCF_INTC_IMRL_INT_MASK21     (0x00200000)
#define MCF_INTC_IMRL_INT_MASK22     (0x00400000)
#define MCF_INTC_IMRL_INT_MASK23     (0x00800000)
#define MCF_INTC_IMRL_INT_MASK24     (0x01000000)
#define MCF_INTC_IMRL_INT_MASK25     (0x02000000)
#define MCF_INTC_IMRL_INT_MASK26     (0x04000000)
#define MCF_INTC_IMRL_INT_MASK27     (0x08000000)
#define MCF_INTC_IMRL_INT_MASK28     (0x10000000)
#define MCF_INTC_IMRL_INT_MASK29     (0x20000000)
#define MCF_INTC_IMRL_INT_MASK30     (0x40000000)
#define MCF_INTC_IMRL_INT_MASK31     (0x80000000)

/* Bit definitions and macros for MCF_INTC_INTFRCH */
#define MCF_INTC_INTFRCH_INTFRC32    (0x00000001)
#define MCF_INTC_INTFRCH_INTFRC33    (0x00000002)
#define MCF_INTC_INTFRCH_INTFRC34    (0x00000004)
#define MCF_INTC_INTFRCH_INTFRC35    (0x00000008)
#define MCF_INTC_INTFRCH_INTFRC36    (0x00000010)
#define MCF_INTC_INTFRCH_INTFRC37    (0x00000020)
#define MCF_INTC_INTFRCH_INTFRC38    (0x00000040)
#define MCF_INTC_INTFRCH_INTFRC39    (0x00000080)
#define MCF_INTC_INTFRCH_INTFRC40    (0x00000100)
#define MCF_INTC_INTFRCH_INTFRC41    (0x00000200)
#define MCF_INTC_INTFRCH_INTFRC42    (0x00000400)
#define MCF_INTC_INTFRCH_INTFRC43    (0x00000800)
#define MCF_INTC_INTFRCH_INTFRC44    (0x00001000)
#define MCF_INTC_INTFRCH_INTFRC45    (0x00002000)
#define MCF_INTC_INTFRCH_INTFRC46    (0x00004000)
#define MCF_INTC_INTFRCH_INTFRC47    (0x00008000)
#define MCF_INTC_INTFRCH_INTFRC48    (0x00010000)
#define MCF_INTC_INTFRCH_INTFRC49    (0x00020000)
#define MCF_INTC_INTFRCH_INTFRC50    (0x00040000)
#define MCF_INTC_INTFRCH_INTFRC51    (0x00080000)
#define MCF_INTC_INTFRCH_INTFRC52    (0x00100000)
#define MCF_INTC_INTFRCH_INTFRC53    (0x00200000)
#define MCF_INTC_INTFRCH_INTFRC54    (0x00400000)
#define MCF_INTC_INTFRCH_INTFRC55    (0x00800000)
#define MCF_INTC_INTFRCH_INTFRC56    (0x01000000)
#define MCF_INTC_INTFRCH_INTFRC57    (0x02000000)
#define MCF_INTC_INTFRCH_INTFRC58    (0x04000000)
#define MCF_INTC_INTFRCH_INTFRC59    (0x08000000)
#define MCF_INTC_INTFRCH_INTFRC60    (0x10000000)
#define MCF_INTC_INTFRCH_INTFRC61    (0x20000000)
#define MCF_INTC_INTFRCH_INTFRC62    (0x40000000)
#define MCF_INTC_INTFRCH_INTFRC63    (0x80000000)

/* Bit definitions and macros for MCF_INTC_INTFRCL */
#define MCF_INTC_INTFRCL_INTFRC1     (0x00000002)
#define MCF_INTC_INTFRCL_INTFRC2     (0x00000004)
#define MCF_INTC_INTFRCL_INTFRC3     (0x00000008)
#define MCF_INTC_INTFRCL_INTFRC4     (0x00000010)
#define MCF_INTC_INTFRCL_INTFRC5     (0x00000020)
#define MCF_INTC_INTFRCL_INT6        (0x00000040)
#define MCF_INTC_INTFRCL_INT7        (0x00000080)
#define MCF_INTC_INTFRCL_INT8        (0x00000100)
#define MCF_INTC_INTFRCL_INT9        (0x00000200)
#define MCF_INTC_INTFRCL_INT10       (0x00000400)
#define MCF_INTC_INTFRCL_INTFRC11    (0x00000800)
#define MCF_INTC_INTFRCL_INTFRC12    (0x00001000)
#define MCF_INTC_INTFRCL_INTFRC13    (0x00002000)
#define MCF_INTC_INTFRCL_INTFRC14    (0x00004000)
#define MCF_INTC_INTFRCL_INT15       (0x00008000)
#define MCF_INTC_INTFRCL_INTFRC16    (0x00010000)
#define MCF_INTC_INTFRCL_INTFRC17    (0x00020000)
#define MCF_INTC_INTFRCL_INTFRC18    (0x00040000)
#define MCF_INTC_INTFRCL_INTFRC19    (0x00080000)
#define MCF_INTC_INTFRCL_INTFRC20    (0x00100000)
#define MCF_INTC_INTFRCL_INTFRC21    (0x00200000)
#define MCF_INTC_INTFRCL_INTFRC22    (0x00400000)
#define MCF_INTC_INTFRCL_INTFRC23    (0x00800000)
#define MCF_INTC_INTFRCL_INTFRC24    (0x01000000)
#define MCF_INTC_INTFRCL_INTFRC25    (0x02000000)
#define MCF_INTC_INTFRCL_INTFRC26    (0x04000000)
#define MCF_INTC_INTFRCL_INTFRC27    (0x08000000)
#define MCF_INTC_INTFRCL_INTFRC28    (0x10000000)
#define MCF_INTC_INTFRCL_INTFRC29    (0x20000000)
#define MCF_INTC_INTFRCL_INTFRC30    (0x40000000)
#define MCF_INTC_INTFRCL_INTFRC31    (0x80000000)

/* Bit definitions and macros for MCF_INTC_IRLR */
#define MCF_INTC_IRLR_IRQ(x)         (((x)&0x7F)<<1)

/* Bit definitions and macros for MCF_INTC_IACKLPR */
#define MCF_INTC_IACKLPR_PRI(x)      (((x)&0x0F)<<0)
#define MCF_INTC_IACKLPR_LEVEL(x)    (((x)&0x07)<<4)

/* Bit definitions and macros for MCF_INTC_ICRn */
#define MCF_INTC_ICRn_IP(x)          (((x)&0x07)<<0)
#define MCF_INTC_ICRn_IL(x)          (((x)&0x07)<<3)

#endif /* __MCF548X_INTC_H__ */
